/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawo;
import com.google.android.gms.internal.zzaxh;

public final class zzaxg
extends UIController {
    private final ImageView zzavt;
    private final ImageHints zzauR;
    private final Bitmap zzavu;
    private final ImagePicker zzatJ;
    private final zzawo zzavv;

    public zzaxg(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzavt = imageView;
        this.zzauR = imageHints;
        this.zzavu = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzatJ = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzavv = new zzawo(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzavv.zza(new zzaxh(this));
        this.zzavt.setImageBitmap(this.zzavu);
        this.zzoi();
    }

    @Override
    public final void onSessionEnded() {
        this.zzavv.clear();
        this.zzavt.setImageBitmap(this.zzavu);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzoi();
    }

    private final void zzoi() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzavt.setImageBitmap(this.zzavu);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzaxg zzaxg2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzaxg2.zzatJ != null && (webImage = zzaxg2.zzatJ.onPickImage(mediaInfo.getMetadata(), zzaxg2.zzauR)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzavt.setImageBitmap(this.zzavu);
            return;
        }
        this.zzavv.zzm(uri);
    }

    static /* synthetic */ ImageView zza(zzaxg zzaxg2) {
        return zzaxg2.zzavt;
    }
}

