/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzava;
import com.google.android.gms.internal.zzavb;
import com.google.android.gms.internal.zzavn;
import com.google.android.gms.internal.zzavo;
import com.google.android.gms.internal.zzavp;

public final class zzavm
implements RemoteMediaClient.Listener {
    private final Context zzarM;
    private final CastOptions zzauY;
    private final zzava zzasB;
    private final ComponentName zzauZ;
    private final zzavb zzava;
    private final zzavb zzavb;
    private RemoteMediaClient zzase;
    private CastDevice zzaoX;
    private MediaSessionCompat zzavc;
    private MediaSessionCompat.Callback zzavd;
    private boolean mIsAttached;

    public zzavm(Context context, CastOptions castOptions, zzava zzava2) {
        this.zzarM = context;
        this.zzauY = castOptions;
        this.zzasB = zzava2;
        this.zzauZ = this.zzauY.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzauY.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzarM, this.zzauY.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzava = new zzavb(this.zzarM);
        this.zzava.zza(new zzavn(this));
        this.zzavb = new zzavb(this.zzarM);
        this.zzavb.zza(new zzavo(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mIsAttached || this.zzauY == null || this.zzauY.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzase = remoteMediaClient;
        this.zzase.addListener(this);
        this.zzaoX = castDevice;
        if (!zzq.zzse()) {
            ((AudioManager)this.zzarM.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzarM, this.zzauY.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzarM, (int)0, (Intent)intent, (int)0);
        this.zzavc = new MediaSessionCompat(this.zzarM, "CastMediaSession", componentName, pendingIntent);
        this.zzavc.setFlags(3);
        this.zza(0, null);
        if (this.zzaoX != null && !TextUtils.isEmpty((CharSequence)this.zzaoX.getFriendlyName())) {
            this.zzavc.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzarM.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzaoX.getFriendlyName()})).build());
        }
        this.zzavd = new zzavp(this);
        this.zzavc.setCallback(this.zzavd);
        this.zzavc.setActive(true);
        this.zzasB.setMediaSessionCompat(this.zzavc);
        this.mIsAttached = true;
        this.zzoe();
    }

    public final void zzab(int n) {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        if (this.zzase != null) {
            this.zzase.removeListener(this);
        }
        if (!zzq.zzse()) {
            ((AudioManager)this.zzarM.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzasB.setMediaSessionCompat(null);
        if (this.zzava != null) {
            this.zzava.clear();
        }
        if (this.zzavb != null) {
            this.zzavb.clear();
        }
        if (this.zzavc != null) {
            this.zzavc.setSessionActivity(null);
            this.zzavc.setCallback(null);
            this.zzavc.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzavc.setActive(false);
            this.zzavc.release();
            this.zzavc = null;
        }
        this.zzase = null;
        this.zzaoX = null;
        this.zzavd = null;
        this.zzog();
        if (n == 0) {
            this.zzoh();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzoe();
    }

    @Override
    public final void onStatusUpdated() {
        this.zzoe();
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzoe();
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzoe();
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzoe();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    private final void zzoe() {
        Intent intent;
        int n;
        MediaStatus mediaStatus = this.zzase.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzase.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.zzase.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzog();
            this.zzoh();
            return;
        }
        zzavm zzavm2 = this;
        if (zzavm2.zzauY.getCastMediaOptions().getNotificationOptions() != null && zzavm2.zzase != null) {
            intent = new Intent(zzavm2.zzarM, MediaNotificationService.class);
            intent.setPackage(zzavm2.zzarM.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzavm2.zzase.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzavm2.zzase.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzavm2.zzaoX);
            zzavm zzavm3 = zzavm2;
            intent.putExtra("extra_media_session_token", zzavm3.zzavc == null ? null : zzavm3.zzavc.getSessionToken());
            MediaStatus mediaStatus2 = zzavm2.zzase.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl4 = false;
                boolean bl5 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl4 = true;
                        bl5 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl5 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl4 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl4);
                intent.putExtra("extra_can_skip_prev", bl5);
            }
            zzavm2.zzarM.startService(intent);
        }
        if (!bl) {
            zzavm2 = this;
            if (zzavm2.zzauY.getEnableReconnectionService()) {
                intent = new Intent(zzavm2.zzarM, ReconnectionService.class);
                intent.setPackage(zzavm2.zzarM.getPackageName());
                zzavm2.zzarM.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzavc.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzavc.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        this.zzavc.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
        zzavm zzavm2 = this;
        if (zzavm2.zzauZ == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzavm2.zzauZ);
            pendingIntent = PendingIntent.getActivity((Context)zzavm2.zzarM, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzavc.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzavm2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzavm2.zzof().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzavm2.zzavc.setMetadata(builder.build());
        Uri uri = zzavm2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzavm2.zzava.zzm(uri);
        } else {
            zzavm2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzavm2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzavm2.zzavb.zzm(uri2);
            return;
        }
        zzavm2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzavc.setMetadata(this.zzof().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzavc.setMetadata(this.zzof().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzavc.setMetadata(this.zzof().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzauY.getCastMediaOptions().getImagePicker() != null ? this.zzauY.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzof() {
        MediaMetadataCompat mediaMetadataCompat = this.zzavc.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzog() {
        if (this.zzauY.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzarM, MediaNotificationService.class);
        intent.setPackage(this.zzarM.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzarM.stopService(intent);
    }

    private final void zzoh() {
        if (!this.zzauY.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzarM, ReconnectionService.class);
        intent.setPackage(this.zzarM.getPackageName());
        this.zzarM.stopService(intent);
    }

    static /* synthetic */ void zza(zzavm zzavm2, Bitmap bitmap, int n) {
        zzavm2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzavm zzavm2) {
        return zzavm2.zzase;
    }
}

