/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaus;
import com.google.android.gms.internal.zzauw;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View zzasl;
        private int zzasm;
        private String zzasn;
        private OnOverlayDismissedListener zzaso;
        private boolean zzasp;
        private float zzasq;
        private String zzasr;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbo.zzu((Object)activity);
            this.zzasl = ((MenuItem)zzbo.zzu((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbo.zzu((Object)activity);
            this.zzasl = (View)zzbo.zzu((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzasm = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzasn = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzasn = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzaso = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzasp = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzasq = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzasq = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzasr = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzasr = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zznA() {
            return this.zzasl;
        }

        public final OnOverlayDismissedListener zznB() {
            return this.zzaso;
        }

        public final int zznC() {
            return this.zzasm;
        }

        public final boolean zznD() {
            return this.zzasp;
        }

        public final String zznE() {
            return this.zzasn;
        }

        public final String zznF() {
            return this.zzasr;
        }

        public final float zznG() {
            return this.zzasq;
        }

        public IntroductoryOverlay build() {
            if (zzq.zzrZ()) {
                return new zzaus(this);
            }
            return new zzauw(this);
        }
    }

    public static final class zza {
        public static void zzal(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzam(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

