/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzk;
import com.google.android.gms.cast.framework.zzq;
import com.google.android.gms.cast.framework.zzw;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzauj;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.internal.zzavb;
import com.google.android.gms.internal.zzayo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzayo zzarK = new zzayo("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzarL;
    private final Context zzarM;
    private final zzk zzarN;
    private final SessionManager zzarO;
    private final zze zzarP;
    private final CastOptions zzarQ;
    private zzavb zzarR;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (zzarL == null) {
            OptionsProvider optionsProvider = CastContext.zzak(context.getApplicationContext());
            zzarL = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzarL;
    }

    private static OptionsProvider zzak(Context context) throws IllegalStateException {
        try {
            String string = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzarM = context.getApplicationContext();
        this.zzarQ = castOptions;
        this.zzarR = new zzavb(MediaRouter.getInstance((Context)this.zzarM));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzauk zzauk2 = new zzauk(this.zzarM, castOptions, this.zzarR);
        hashMap.put(zzauk2.getCategory(), zzauk2.zznH());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbo.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzbo.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbo.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zznH());
            }
        }
        this.zzarN = zzauj.zza(this.zzarM, castOptions, this.zzarR, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzarN.zznt();
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzk.class.getSimpleName()});
        }
        this.zzarP = object3 == null ? null : new zze((zzq)object3);
        Object var7_10 = null;
        try {
            zzw zzw2 = this.zzarN.zzns();
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzk.class.getSimpleName()});
        }
        this.zzarO = var7_12 == null ? null : new SessionManager((zzw)var7_12);
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzarQ;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzarO;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzarN.zznr());
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzk.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzarO.getCastState();
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        try {
            return this.zzarN.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzk.class.getSimpleName()});
            return false;
        }
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        zzbo.zzu((Object)appVisibilityListener);
        try {
            this.zzarN.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzk.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzarN.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzk.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        zzbo.zzu((Object)castStateListener);
        this.zzarO.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzarO.removeCastStateListener(castStateListener);
    }

    public final zze zzno() {
        zzbo.zzcz((String)"Must be called from the main thread.");
        return this.zzarP;
    }

    @Deprecated
    public final void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbo.zzcz((String)"Must be called from the main thread.");
        if (com.google.android.gms.common.util.zzq.zzrZ()) {
            return false;
        }
        CastSession castSession = this.zzarO.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzarK.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zznp() {
        try {
            return this.zzarN.zznu();
        }
        catch (RemoteException remoteException) {
            zzarK.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzk.class.getSimpleName()});
            return null;
        }
    }
}

