/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.hu;
import com.google.android.gms.internal.hw;

final class zzl
extends Drawable {
    private final int zzatx;
    private final int zzaty;
    private final int zzatz;
    private final Rect zzasQ = new Rect();
    private final Rect zzatr = new Rect();
    private final Paint zzasL = new Paint();
    private float zzasM;
    private float zzato = 1.0f;
    private float centerX;
    private float centerY;
    private float zzatA = 0.0f;
    private float zzatB = 0.0f;
    private int zzatC = 244;

    public zzl(Context context) {
        if (zzq.zzse()) {
            Context context2 = context;
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843827, typedValue, true);
            this.setColor(ColorUtils.setAlphaComponent((int)typedValue.data, (int)244));
        } else {
            this.setColor(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzasL.setAntiAlias(true);
        this.zzasL.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zzatx = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzaty = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzatz = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public final void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX + this.zzatA, this.centerY + this.zzatB, this.zzasM * this.zzato, this.zzasL);
    }

    public final void setAlpha(int n) {
        this.zzasL.setAlpha(n);
        this.invalidateSelf();
    }

    public final int getAlpha() {
        return this.zzasL.getAlpha();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzasL.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public final int getOpacity() {
        return -3;
    }

    @ColorInt
    public final int getColor() {
        return this.zzasL.getColor();
    }

    public final void setColor(@ColorInt int n) {
        this.zzasL.setColor(n);
        this.zzatC = this.zzasL.getAlpha();
        this.invalidateSelf();
    }

    public final void zzb(Rect rect, Rect rect2) {
        this.zzasQ.set(rect);
        this.zzatr.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zzatx) {
            this.centerX = f;
            this.centerY = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.centerX = bl ? rect2.exactCenterX() + (float)this.zzaty : rect2.exactCenterX() - (float)this.zzaty;
            this.centerY = rect2.exactCenterY();
        }
        this.zzasM = (float)this.zzatz + Math.max(zzl.zza(this.centerX, this.centerY, rect), zzl.zza(this.centerX, this.centerY, rect2));
        this.invalidateSelf();
    }

    @UsedByReflection(value="FeatureHighlightView.java")
    public final void setScale(float f) {
        this.zzato = f;
        this.invalidateSelf();
    }

    @UsedByReflection(value="FeatureHighlightView.java")
    public final void setTranslationX(float f) {
        this.zzatA = f;
        this.invalidateSelf();
    }

    @UsedByReflection(value="FeatureHighlightView.java")
    public final void setTranslationY(float f) {
        this.zzatB = f;
        this.invalidateSelf();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final boolean zzd(float f, float f2) {
        return hw.zza(f, f2, this.centerX, this.centerY) < this.zzasM;
    }

    private static float zza(float f, float f2, Rect rect) {
        float f3;
        float f4 = rect.bottom;
        float f5 = rect.right;
        float f6 = rect.top;
        float f7 = rect.left;
        float f8 = f2;
        float f9 = f;
        float f10 = hw.zza(f9, f8, f7, f4);
        float f11 = hw.zza(f9, f8, f5, f4);
        float f12 = hw.zza(f9, f8, f5, f6);
        float f13 = hw.zza(f9, f8, f7, f6);
        return (float)Math.ceil(f3 > f12 && f13 > f11 && f13 > f10 ? f13 : (f12 > f11 && f12 > f10 ? f12 : (f11 > f10 ? f11 : f10)));
    }

    public final Animator zze(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzatC});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)hu.zzEg());
        return objectAnimator.setDuration(350L);
    }
}

