/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzavc;
import com.google.android.gms.internal.zzavx;

public final class zzavw
extends UIController {
    private final ImageView zzavr;
    private final ImageHints zzauP;
    private final Bitmap zzavv;
    private final View zzavw;
    private final ImagePicker zzatH;
    private final zzavc zzavt;

    public zzavw(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzavr = imageView;
        this.zzauP = imageHints;
        this.zzavv = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzavw = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzatH = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzavt = new zzavc(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzavt.zza(new zzavx(this));
        this.zzol();
        this.zzok();
    }

    @Override
    public final void onSessionEnded() {
        this.zzavt.clear();
        this.zzol();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzok();
    }

    private final void zzok() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzol();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzavw zzavw2 = this;
        if ((mediaInfo == null ? null : (uri = zzavw2.zzatH != null && (webImage = zzavw2.zzatH.onPickImage(mediaInfo.getMetadata(), zzavw2.zzauP)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzol();
            return;
        }
        this.zzavt.zzm(uri);
    }

    private final void zzol() {
        if (this.zzavw != null) {
            this.zzavw.setVisibility(0);
            this.zzavr.setVisibility(4);
        }
        if (this.zzavv != null) {
            this.zzavr.setImageBitmap(this.zzavv);
        }
    }

    static /* synthetic */ View zza(zzavw zzavw2) {
        return zzavw2.zzavw;
    }

    static /* synthetic */ ImageView zzb(zzavw zzavw2) {
        return zzavw2.zzavr;
    }
}

