/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzawc;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzawp;
import com.google.android.gms.internal.zzawq;
import com.google.android.gms.internal.zzawr;

public final class zzawo
implements RemoteMediaClient.Listener {
    private final Context zzeof;
    private final CastOptions zzevb;
    private final zzawc zzepx;
    private final ComponentName zzevc;
    private final zzawd zzevd;
    private final zzawd zzeve;
    private RemoteMediaClient zzepa;
    private CastDevice zzeih;
    private MediaSessionCompat zzevf;
    private MediaSessionCompat.Callback zzevg;
    private boolean mIsAttached;

    public zzawo(Context context, CastOptions castOptions, zzawc zzawc2) {
        this.zzeof = context;
        this.zzevb = castOptions;
        this.zzepx = zzawc2;
        this.zzevc = this.zzevb.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzevb.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzeof, this.zzevb.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzevd = new zzawd(this.zzeof);
        this.zzevd.zza(new zzawp(this));
        this.zzeve = new zzawd(this.zzeof);
        this.zzeve.zza(new zzawq(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mIsAttached || this.zzevb == null || this.zzevb.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzepa = remoteMediaClient;
        this.zzepa.addListener(this);
        this.zzeih = castDevice;
        if (!zzp.zzalj()) {
            ((AudioManager)this.zzeof.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzeof, this.zzevb.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzeof, (int)0, (Intent)intent, (int)0);
        this.zzevf = new MediaSessionCompat(this.zzeof, "CastMediaSession", componentName, pendingIntent);
        this.zzevf.setFlags(3);
        this.zza(0, null);
        if (this.zzeih != null && !TextUtils.isEmpty((CharSequence)this.zzeih.getFriendlyName())) {
            this.zzevf.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzeof.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzeih.getFriendlyName()})).build());
        }
        this.zzevg = new zzawr(this);
        this.zzevf.setCallback(this.zzevg);
        this.zzevf.setActive(true);
        this.zzepx.setMediaSessionCompat(this.zzevf);
        this.mIsAttached = true;
        this.zzax(false);
    }

    public final void zzbg(int n) {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        if (this.zzepa != null) {
            this.zzepa.removeListener(this);
        }
        if (!zzp.zzalj()) {
            ((AudioManager)this.zzeof.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzepx.setMediaSessionCompat(null);
        if (this.zzevd != null) {
            this.zzevd.clear();
        }
        if (this.zzeve != null) {
            this.zzeve.clear();
        }
        if (this.zzevf != null) {
            this.zzevf.setSessionActivity(null);
            this.zzevf.setCallback(null);
            this.zzevf.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzevf.setActive(false);
            this.zzevf.release();
            this.zzevf = null;
        }
        this.zzepa = null;
        this.zzeih = null;
        this.zzevg = null;
        this.zzadk();
        if (n == 0) {
            this.zzadl();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzax(boolean bl) {
        int n;
        if (this.zzepa == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzepa.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzepa.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzepa.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzadk();
            this.zzadl();
            return;
        }
        boolean bl5 = bl;
        zzawo zzawo2 = this;
        if (zzawo2.zzevb.getCastMediaOptions().getNotificationOptions() != null && zzawo2.zzepa != null) {
            Intent intent = new Intent(zzawo2.zzeof, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzawo2.zzeof.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzawo2.zzepa.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzawo2.zzepa.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzawo2.zzeih);
            zzawo zzawo3 = zzawo2;
            intent.putExtra("extra_media_session_token", zzawo3.zzevf == null ? null : zzawo3.zzevf.getSessionToken());
            MediaStatus mediaStatus2 = zzawo2.zzepa.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzawo2.zzeof.startService(intent);
        }
        if (!bl2) {
            zzawo2 = this;
            if (zzawo2.zzevb.getEnableReconnectionService()) {
                Intent intent = new Intent(zzawo2.zzeof, ReconnectionService.class);
                intent.setPackage(zzawo2.zzeof.getPackageName());
                zzawo2.zzeof.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzevf.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzevf.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzevf.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzawo zzawo2 = this;
        if (zzawo2.zzevc == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzawo2.zzevc);
            pendingIntent = PendingIntent.getActivity((Context)zzawo2.zzeof, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzevf.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzawo2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzawo2.zzadj().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzawo2.zzevf.setMetadata(builder.build());
        Uri uri = zzawo2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzawo2.zzevd.zzm(uri);
        } else {
            zzawo2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzawo2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzawo2.zzeve.zzm(uri2);
            return;
        }
        zzawo2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzevf.setMetadata(this.zzadj().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzevf.setMetadata(this.zzadj().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzevf.setMetadata(this.zzadj().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzevb.getCastMediaOptions().getImagePicker() != null ? this.zzevb.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzadj() {
        MediaMetadataCompat mediaMetadataCompat = this.zzevf.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzadk() {
        if (this.zzevb.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzeof, MediaNotificationService.class);
        intent.setPackage(this.zzeof.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzeof.stopService(intent);
    }

    private final void zzadl() {
        if (!this.zzevb.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzeof, ReconnectionService.class);
        intent.setPackage(this.zzeof.getPackageName());
        this.zzeof.stopService(intent);
    }

    static /* synthetic */ void zza(zzawo zzawo2, Bitmap bitmap, int n) {
        zzawo2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzawo zzawo2) {
        return zzawo2.zzepa;
    }
}

