/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzaxk;

public final class zzaxj
extends UIController {
    private final ImageView zzevt;
    private final View zzewi;
    private final boolean zzewj;
    private final Drawable zzewk;
    private final String zzewl;
    private final Drawable zzewm;
    private final String zzewn;
    private final Drawable zzewo;
    private final String zzewp;
    private final View.OnClickListener zzevr;

    public zzaxj(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzevt = imageView;
        this.zzewk = drawable2;
        this.zzewm = drawable3;
        this.zzewo = drawable4 != null ? drawable4 : drawable3;
        this.zzewl = context.getString(R.string.cast_play);
        this.zzewn = context.getString(R.string.cast_pause);
        this.zzewp = context.getString(R.string.cast_stop);
        this.zzewi = view;
        this.zzewj = bl;
        this.zzevr = new zzaxk(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevt.setOnClickListener(this.zzevr);
        this.zzado();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevt.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzado();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzaz(true);
    }

    private final void zzado() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevt.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzewk, this.zzewl);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzewo, this.zzewp);
                return;
            }
            this.zza(this.zzewm, this.zzewn);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzaz(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzaz(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzevt.setImageDrawable(drawable2);
        this.zzevt.setContentDescription((CharSequence)string2);
        this.zzevt.setVisibility(0);
        this.zzevt.setEnabled(true);
        if (this.zzewi != null) {
            this.zzewi.setVisibility(8);
        }
    }

    private final void zzaz(boolean bl) {
        if (this.zzewi != null) {
            this.zzewi.setVisibility(0);
        }
        this.zzevt.setVisibility(this.zzewj ? 4 : 0);
        this.zzevt.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzaxj zzaxj2) {
        return zzaxj2.getRemoteMediaClient();
    }
}

