/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzazp;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzazp zzejb = new zzazp("MiniControllerFragment");
    private boolean zzeyj;
    private int zzeyk;
    private int zzeyl;
    private TextView zzeym;
    private int zzeyn;
    private int zzeyo;
    private int zzexu;
    private int[] zzexz;
    private ImageView[] zzeya = new ImageView[3];
    private int zzeyp;
    @DrawableRes
    private int zzexl;
    @DrawableRes
    private int zzexm;
    @DrawableRes
    private int zzexn;
    @DrawableRes
    private int zzeyq;
    @DrawableRes
    private int zzeyr;
    @DrawableRes
    private int zzeys;
    @DrawableRes
    private int zzexo;
    @DrawableRes
    private int zzexp;
    @DrawableRes
    private int zzexq;
    @DrawableRes
    private int zzexr;
    @DrawableRes
    private int zzexs;
    @DrawableRes
    private int zzext;
    private UIMediaController zzeyg;

    public MiniControllerFragment() {
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        MiniControllerFragment miniControllerFragment = this;
        if (miniControllerFragment.zzexz == null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attributeSet2, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            miniControllerFragment.zzeyj = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            miniControllerFragment.zzeyk = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            miniControllerFragment.zzeyl = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            miniControllerFragment.zzeyn = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            miniControllerFragment.zzeyo = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            miniControllerFragment.zzexu = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            miniControllerFragment.zzexl = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzexm = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzexn = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzeyq = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzeyr = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzeys = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzexo = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            miniControllerFragment.zzexp = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            miniControllerFragment.zzexq = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            miniControllerFragment.zzexr = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            miniControllerFragment.zzexs = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            miniControllerFragment.zzext = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = context2.getResources().obtainTypedArray(n);
                zzbp.zzbh((typedArray2.length() == 3 ? 1 : 0) != 0);
                miniControllerFragment.zzexz = new int[typedArray2.length()];
                for (int i = 0; i < typedArray2.length(); ++i) {
                    miniControllerFragment.zzexz[i] = typedArray2.getResourceId(i, 0);
                }
                typedArray2.recycle();
                if (miniControllerFragment.zzeyj) {
                    miniControllerFragment.zzexz[0] = R.id.cast_button_type_empty;
                }
                miniControllerFragment.zzeyp = 0;
                int[] nArray = miniControllerFragment.zzexz;
                int n2 = miniControllerFragment.zzexz.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == R.id.cast_button_type_empty) continue;
                    ++miniControllerFragment.zzeyp;
                }
            } else {
                zzejb.zzf("Unable to read attribute castControlButtons.", new Object[0]);
                miniControllerFragment.zzexz = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzeyg = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzeyg.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzeyn != 0) {
            relativeLayout.setBackgroundResource(this.zzeyn);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzeyk != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzeyk);
        }
        this.zzeym = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzeyl != 0) {
            this.zzeym.setTextAppearance((Context)this.getActivity(), this.zzeyl);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzeyo != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzeyo, PorterDuff.Mode.SRC_IN);
        }
        this.zzeyg.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzeyg.bindTextViewToSmartSubtitle(this.zzeym);
        this.zzeyg.bindProgressBar(progressBar);
        this.zzeyg.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzeyj) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzeyg.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzeya[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzeya[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzeya[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzeyg != null) {
            this.zzeyg.dispose();
            this.zzeyg = null;
        }
        super.onDestroy();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzexz[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzeya[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzeyg;
    }

    private final void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzexz[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzexl;
                int n5 = this.zzexm;
                int n6 = this.zzexn;
                if (this.zzeyp == 1) {
                    n4 = this.zzeyq;
                    n5 = this.zzeyr;
                    n6 = this.zzeys;
                }
                Drawable drawable2 = zzb.zza(this.getContext(), this.zzexu, n4);
                Drawable drawable3 = zzb.zza(this.getContext(), this.zzexu, n5);
                Drawable drawable4 = zzb.zza(this.getContext(), this.zzexu, n6);
                imageView.setImageDrawable(drawable3);
                int n7 = n;
                MiniControllerFragment miniControllerFragment = this;
                ProgressBar progressBar = new ProgressBar(miniControllerFragment.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(8, n7);
                layoutParams.addRule(6, n7);
                layoutParams.addRule(5, n7);
                layoutParams.addRule(7, n7);
                layoutParams.addRule(15);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                progressBar.setVisibility(8);
                Drawable drawable5 = progressBar.getIndeterminateDrawable();
                if (miniControllerFragment.zzeyo != 0 && drawable5 != null) {
                    drawable5.setColorFilter(miniControllerFragment.zzeyo, PorterDuff.Mode.SRC_IN);
                }
                ProgressBar progressBar2 = progressBar;
                relativeLayout.addView((View)progressBar2);
                this.zzeyg.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar2, true);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzexo));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzeyg.bindViewToSkipPrev((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzexp));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzeyg.bindViewToSkipNext((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzexq));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzeyg.bindViewToRewind((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzexr));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzeyg.bindViewToForward((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzexs));
                this.zzeyg.bindImageViewToMuteToggle(imageView);
                return;
            }
            if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexu, this.zzext));
                this.zzeyg.bindViewToClosedCaption((View)imageView);
            }
        }
    }
}

