/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzaxh;
import com.google.android.gms.internal.zzaxi;
import com.google.android.gms.internal.zzazp;

public final class zzaxg
extends UIController {
    private static final zzazp zzejb = new zzazp("MuteToggleUIController");
    private final ImageView zzevt;
    private final String zzewf;
    private final String zzewg;
    private final Context zzeof;
    private final Cast.Listener zzeii;
    private final View.OnClickListener zzevr;

    public zzaxg(ImageView imageView, Context context) {
        this.zzevt = imageView;
        this.zzeof = context.getApplicationContext();
        this.zzewf = this.zzeof.getString(R.string.cast_mute);
        this.zzewg = this.zzeof.getString(R.string.cast_unmute);
        this.zzeii = new zzaxh(this);
        this.zzevr = new zzaxi(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevt.setOnClickListener(this.zzevr);
        castSession.addCastListener(this.zzeii);
        this.zzado();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevt.setOnClickListener(null);
        CastSession castSession = CastContext.getSharedInstance(this.zzeof).getSessionManager().getCurrentCastSession();
        if (castSession != null) {
            castSession.removeCastListener(this.zzeii);
        }
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzado();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzevt.setEnabled(false);
    }

    private final void zzado() {
        CastSession castSession = CastContext.getSharedInstance(this.zzeof).getSessionManager().getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                this.zzevt.setEnabled(false);
            } else {
                this.zzevt.setEnabled(true);
            }
            if (castSession.isMute()) {
                this.zzay(false);
                return;
            }
            this.zzay(true);
            return;
        }
        this.zzevt.setEnabled(false);
    }

    private final void zzay(boolean bl) {
        this.zzevt.setSelected(bl);
        this.zzevt.setContentDescription((CharSequence)(bl ? this.zzewf : this.zzewg));
    }

    static /* synthetic */ void zza(zzaxg zzaxg2) {
        zzaxg2.zzado();
    }

    static /* synthetic */ Context zzb(zzaxg zzaxg2) {
        return zzaxg2.zzeof;
    }

    static /* synthetic */ void zza(zzaxg zzaxg2, boolean bl) {
        zzaxg2.zzay(bl);
    }

    static /* synthetic */ zzazp zzadr() {
        return zzejb;
    }
}

