/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbck {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzeoo;
    private final List<String> zzeop;
    private final boolean zzeoq;
    private final LaunchOptions zzekr;
    private final boolean zzeor;
    private final CastMediaOptions zzeos;
    private final boolean zzeot;
    private final double zzeou;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzeoo = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzeop = new ArrayList<String>(n);
        if (n > 0) {
            this.zzeop.addAll(list);
        }
        this.zzeoq = bl;
        this.zzekr = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzeor = bl2;
        this.zzeos = castMediaOptions;
        this.zzeot = bl3;
        this.zzeou = d;
    }

    public String getReceiverApplicationId() {
        return this.zzeoo;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzeop);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzeoq;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzekr;
    }

    public boolean getResumeSavedSession() {
        return this.zzeor;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzeos;
    }

    public boolean getEnableReconnectionService() {
        return this.zzeot;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzeou;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbcn.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbcn.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzeoo;
        private List<String> zzeop = new ArrayList<String>();
        private boolean zzeoq;
        private LaunchOptions zzekr = new LaunchOptions();
        private boolean zzeor = true;
        private CastMediaOptions zzeos = new CastMediaOptions.Builder().build();
        private boolean zzeot = true;
        private double zzeou = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzeoo = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzeop = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzeoq = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzekr = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzeor = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzeos = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzeot = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzeou = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzeoo, this.zzeop, this.zzeoq, this.zzekr, this.zzeor, this.zzeos, this.zzeot, this.zzeou);
        }
    }
}

