/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzavl;
import com.google.android.gms.internal.zzavn;
import com.google.android.gms.internal.zzawp;
import com.google.android.gms.internal.zzazx;
import com.google.android.gms.internal.zzazy;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzazx zzejc = new zzazx("CastSession");
    private final Context zzeog;
    private final Set<Cast.Listener> zzeov = new HashSet<Cast.Listener>();
    private final zzl zzeow;
    private final CastOptions zzeom;
    private final Cast.CastApi zzeox;
    private final zzavn zzeoy;
    private final zzawp zzeoz;
    private GoogleApiClient zzepa;
    private RemoteMediaClient zzepb;
    private CastDevice zzepc;
    private Cast.ApplicationConnectionResult zzepd;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzavn zzavn2, zzawp zzawp2) {
        super(context, string2, string3);
        this.zzeog = context.getApplicationContext();
        this.zzeom = castOptions;
        this.zzeox = castApi;
        this.zzeoy = zzavn2;
        this.zzeoz = zzawp2;
        this.zzeow = zzavl.zza(context, castOptions, this.zzacb(), new zzb(this, null));
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzeow.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepb;
    }

    public CastDevice getCastDevice() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepc;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            this.zzeox.requestStatus(this.zzepa);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.getActiveInputState(this.zzepa);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.getStandbyState(this.zzepa);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.getApplicationMetadata(this.zzepa);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.getApplicationStatus(this.zzepa);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            this.zzeox.setVolume(this.zzepa, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.getVolume(this.zzepa);
        }
        return 0.0;
    }

    public final zzawp zzabv() {
        return this.zzeoz;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            this.zzeox.setMute(this.zzepa, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.isMute(this.zzepa);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepd;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            this.zzeox.setMessageReceivedCallbacks(this.zzepa, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            this.zzeox.removeMessageReceivedCallbacks(this.zzepa, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepa != null) {
            return this.zzeox.sendMessage(this.zzepa, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeov.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeov.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzepc = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzepc == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzepa != null) {
            this.zzepa.disconnect();
            this.zzepa = null;
        }
        zzejc.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzepc});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzeom;
        CastDevice castDevice = this.zzepc;
        Context context = this.zzeog;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzepa = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzepa.connect();
    }

    private final void zzbd(int n) {
        this.zzeoz.zzbg(n);
        if (this.zzepa != null) {
            this.zzepa.disconnect();
            this.zzepa = null;
        }
        this.zzepc = null;
        if (this.zzepb != null) {
            try {
                this.zzepb.zzc(null);
            }
            catch (IOException iOException) {
                zzejc.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.zzepb = null;
        }
        this.zzepd = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (this.zzepb == null) {
            return 0L;
        }
        return this.zzepb.getStreamDuration() - this.zzepb.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzepf;

        private zzb(CastSession castSession) {
            this.zzepf = castSession;
        }

        @Override
        public final void zzr(String string2, String string3) {
            this.zzepf.zzeox.joinApplication(this.zzepf.zzepa, string2, string3).setResultCallback((ResultCallback)new zza(this.zzepf, "joinApplication"));
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            this.zzepf.zzeox.launchApplication(this.zzepf.zzepa, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzepf, "launchApplication"));
        }

        @Override
        public final void zzez(String string2) {
            this.zzepf.zzeox.stopApplication(this.zzepf.zzepa, string2);
        }

        @Override
        public final void zzbd(int n) {
            this.zzepf.zzbd(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzepe;
        private /* synthetic */ CastSession zzepf;

        zza(CastSession castSession, String string2) {
            this.zzepf = castSession;
            this.zzepe = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzepf.zzepd = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzejc.zzb("%s() -> success result", new Object[]{zza2.zzepe});
                    zza2.zzepf.zzepb = new RemoteMediaClient(new zzazy(null, zzh.zzald()), zza2.zzepf.zzeox);
                    try {
                        zza2.zzepf.zzepb.zzc(zza2.zzepf.zzepa);
                        zza2.zzepf.zzepb.zzadd();
                        zza2.zzepf.zzepb.requestStatus();
                        zza2.zzepf.zzeoz.zza(zza2.zzepf.zzepb, zza2.zzepf.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzejc.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzepf.zzepb = null;
                    }
                    zza2.zzepf.zzeow.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzejc.zzb("%s() -> failure result", new Object[]{zza2.zzepe});
                zza2.zzepf.zzeow.zzbe(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzepf;

        private zzc(CastSession castSession) {
            this.zzepf = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzepf.zzbd(n);
            this.zzepf.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzepf.zzeov).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzepf;

        private zzd(CastSession castSession) {
            this.zzepf = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzepf.zzepb != null) {
                    try {
                        this.zzepf.zzepb.zzadd();
                        this.zzepf.zzepb.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzejc.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzepf.zzepb = null;
                    }
                }
                this.zzepf.zzeow.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzepf.zzeow.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzepf.zzeow.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

