/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzavu;
import com.google.android.gms.internal.zzavy;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzepi;
        private int zzepj;
        private String zzepk;
        private OnOverlayDismissedListener zzepl;
        private boolean zzepm;
        private float zzepn;
        private String zzepo;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzepi = ((MenuItem)zzbp.zzu((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzepi = (View)zzbp.zzu((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzepj = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzepk = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzepk = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzepl = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzepm = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzepn = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzepn = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzepo = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzepo = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzace() {
            return this.zzepi;
        }

        public final OnOverlayDismissedListener zzacf() {
            return this.zzepl;
        }

        public final int zzacg() {
            return this.zzepj;
        }

        public final boolean zzach() {
            return this.zzepm;
        }

        public final String zzaci() {
            return this.zzepk;
        }

        public final String zzacj() {
            return this.zzepo;
        }

        public final float zzack() {
            return this.zzepn;
        }

        public IntroductoryOverlay build() {
            if (zzp.zzalf()) {
                return new zzavu(this);
            }
            return new zzavy(this);
        }
    }

    public static final class zza {
        public static void zzbn(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbo(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

