/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzac;
import com.google.android.gms.cast.framework.zzad;
import com.google.android.gms.cast.framework.zzt;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzavl;
import com.google.android.gms.internal.zzazx;

public abstract class Session {
    private static final zzazx zzejc = new zzazx("Session");
    private final zzt zzepr;
    private final zza zzeps = new zza(this, null);

    protected Session(Context context, String string2, String string3) {
        this.zzepr = zzavl.zza(context, string2, string3, this.zzeps);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    public long getSessionRemainingTimeMs() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.getCategory();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzt.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzt.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isConnected();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzt.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isResuming();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return this.zzepr.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzt.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzepr.notifySessionStarted(string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzepr.notifyFailedToStartSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzepr.notifySessionEnded(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzepr.notifySessionResumed(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzepr.notifyFailedToResumeSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzepr.notifySessionSuspended(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzt.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzacb() {
        try {
            return this.zzepr.zzacb();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzt.class.getSimpleName()});
            return null;
        }
    }

    final class zza
    extends zzac {
        private /* synthetic */ Session zzept;

        private zza(Session session) {
            this.zzept = session;
        }

        @Override
        public final IObjectWrapper zzacd() {
            return zzn.zzw((Object)this.zzept);
        }

        @Override
        public final void start(Bundle bundle) {
            this.zzept.start(bundle);
        }

        @Override
        public final void resume(Bundle bundle) {
            this.zzept.resume(bundle);
        }

        @Override
        public final void end(boolean bl) {
            this.zzept.end(bl);
        }

        @Override
        public final long getSessionRemainingTimeMs() {
            return this.zzept.getSessionRemainingTimeMs();
        }

        /* synthetic */ zza(Session session, zzad zzad2) {
            this(session);
        }
    }
}

