/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.widget.Toast;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzae;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzazx;

public class SessionManager {
    private static final zzazx zzejc = new zzazx("SessionManager");
    private final zzv zzepu;
    private final Context mContext;

    public SessionManager(zzv zzv2, Context context) {
        this.zzepu = zzv2;
        this.mContext = context;
    }

    public Session getCurrentSession() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            return (Session)zzn.zzx((IObjectWrapper)this.zzepu.zzacc());
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzv.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            this.zzepu.zzb(true, bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzv.class.getSimpleName()});
            return;
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzbp.zzu(sessionManagerListener);
        zzbp.zzu(clazz);
        zzbp.zzfy((String)"Must be called from the main thread.");
        try {
            this.zzepu.zza(new zzae<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzv.class.getSimpleName()});
            return;
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzbp.zzu((Object)clazz);
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.zzepu.zzb(new zzae<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzv.class.getSimpleName()});
            return;
        }
    }

    public void startSession(Intent intent) {
        try {
            Bundle bundle = intent.getExtras();
            if (bundle == null || bundle.getString("CAST_INTENT_TO_CAST_ROUTE_ID_KEY") == null) {
                return;
            }
            String string2 = bundle.getString("CAST_INTENT_TO_CAST_DEVICE_NAME_KEY");
            String string3 = this.mContext.getString(R.string.cast_connecting_to_device, new Object[]{string2});
            Toast.makeText((Context)this.mContext, (CharSequence)string3, (int)1).show();
            this.zzepu.zzg(new Bundle(bundle));
            intent.removeExtra("CAST_INTENT_TO_CAST_ROUTE_ID_KEY");
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"startSession", zzv.class.getSimpleName()});
            return;
        }
    }

    final int getCastState() {
        try {
            return this.zzepu.getCastState();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzv.class.getSimpleName()});
            return 1;
        }
    }

    final void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzbp.zzu((Object)castStateListener);
        try {
            this.zzepu.zza(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzv.class.getSimpleName()});
            return;
        }
    }

    final void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.zzepu.zzb(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzv.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzabu() {
        try {
            return this.zzepu.zzaca();
        }
        catch (RemoteException remoteException) {
            zzejc.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzv.class.getSimpleName()});
            return null;
        }
    }
}

