/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdff;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzeqj = new Paint();
    private final Paint zzerj = new Paint();
    private final Rect zzeqo = new Rect();
    private final int zzerk;
    private final int zzerl;
    private float zzeqk;
    private float zzerm = 1.0f;
    private float centerX;
    private float centerY;
    private float zzern;
    private float zzero;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzerk = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzerl = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzeqj.setAntiAlias(true);
        this.zzeqj.setStyle(Paint.Style.FILL);
        this.zzerj.setAntiAlias(true);
        this.zzerj.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzeqj.setColor(-1);
        innerZoneDrawable.zzerj.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzero > 0.0f) {
            float f = this.zzeqk * this.zzern;
            this.zzerj.setAlpha((int)((float)this.zzerl * this.zzero));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzerj);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzeqk * this.zzerm, this.zzeqj);
    }

    public void setAlpha(int n) {
        this.zzeqj.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzeqj.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzerm = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzern = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzero = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzeqo.set(rect);
        this.centerX = this.zzeqo.exactCenterX();
        this.centerY = this.zzeqo.exactCenterY();
        this.zzeqk = Math.max((float)this.zzerk, Math.max((float)this.zzeqo.width() / 2.0f, (float)this.zzeqo.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzacw() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdff.zzbjh());
        return objectAnimator.setDuration(200L);
    }
}

