/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawq;
import com.google.android.gms.internal.zzawr;
import com.google.android.gms.internal.zzaws;

public final class zzawp
implements RemoteMediaClient.Listener {
    private final Context zzeog;
    private final CastOptions zzevf;
    private final zzawd zzepz;
    private final ComponentName zzevg;
    private final zzawe zzevh;
    private final zzawe zzevi;
    private RemoteMediaClient zzepb;
    private CastDevice zzeii;
    private MediaSessionCompat zzevj;
    private MediaSessionCompat.Callback zzevk;
    private boolean mIsAttached;

    public zzawp(Context context, CastOptions castOptions, zzawd zzawd2) {
        this.zzeog = context;
        this.zzevf = castOptions;
        this.zzepz = zzawd2;
        this.zzevg = this.zzevf.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzevf.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzeog, this.zzevf.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzevh = new zzawe(this.zzeog);
        this.zzevh.zza(new zzawq(this));
        this.zzevi = new zzawe(this.zzeog);
        this.zzevi.zza(new zzawr(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mIsAttached || this.zzevf == null || this.zzevf.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzepb = remoteMediaClient;
        this.zzepb.addListener(this);
        this.zzeii = castDevice;
        if (!zzp.zzalk()) {
            ((AudioManager)this.zzeog.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzeog, this.zzevf.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzeog, (int)0, (Intent)intent, (int)0);
        this.zzevj = new MediaSessionCompat(this.zzeog, "CastMediaSession", componentName, pendingIntent);
        this.zzevj.setFlags(3);
        this.zza(0, null);
        if (this.zzeii != null && !TextUtils.isEmpty((CharSequence)this.zzeii.getFriendlyName())) {
            this.zzevj.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzeog.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzeii.getFriendlyName()})).build());
        }
        this.zzevk = new zzaws(this);
        this.zzevj.setCallback(this.zzevk);
        this.zzevj.setActive(true);
        this.zzepz.setMediaSessionCompat(this.zzevj);
        this.mIsAttached = true;
        this.zzax(false);
    }

    public final void zzbg(int n) {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        if (this.zzepb != null) {
            this.zzepb.removeListener(this);
        }
        if (!zzp.zzalk()) {
            ((AudioManager)this.zzeog.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzepz.setMediaSessionCompat(null);
        if (this.zzevh != null) {
            this.zzevh.clear();
        }
        if (this.zzevi != null) {
            this.zzevi.clear();
        }
        if (this.zzevj != null) {
            this.zzevj.setSessionActivity(null);
            this.zzevj.setCallback(null);
            this.zzevj.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzevj.setActive(false);
            this.zzevj.release();
            this.zzevj = null;
        }
        this.zzepb = null;
        this.zzeii = null;
        this.zzevk = null;
        this.zzadl();
        if (n == 0) {
            this.zzadm();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzax(boolean bl) {
        int n;
        if (this.zzepb == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzepb.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzepb.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzepb.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzadl();
            this.zzadm();
            return;
        }
        boolean bl5 = bl;
        zzawp zzawp2 = this;
        if (zzawp2.zzevf.getCastMediaOptions().getNotificationOptions() != null && zzawp2.zzepb != null) {
            Intent intent = new Intent(zzawp2.zzeog, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzawp2.zzeog.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzawp2.zzepb.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzawp2.zzepb.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzawp2.zzeii);
            zzawp zzawp3 = zzawp2;
            intent.putExtra("extra_media_session_token", zzawp3.zzevj == null ? null : zzawp3.zzevj.getSessionToken());
            MediaStatus mediaStatus2 = zzawp2.zzepb.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzawp2.zzeog.startService(intent);
        }
        if (!bl2) {
            zzawp2 = this;
            if (zzawp2.zzevf.getEnableReconnectionService()) {
                Intent intent = new Intent(zzawp2.zzeog, ReconnectionService.class);
                intent.setPackage(zzawp2.zzeog.getPackageName());
                zzawp2.zzeog.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzevj.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzevj.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzevj.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzawp zzawp2 = this;
        if (zzawp2.zzevg == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzawp2.zzevg);
            pendingIntent = PendingIntent.getActivity((Context)zzawp2.zzeog, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzevj.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzawp2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzawp2.zzadk().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzawp2.zzevj.setMetadata(builder.build());
        Uri uri = zzawp2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzawp2.zzevh.zzl(uri);
        } else {
            zzawp2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzawp2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzawp2.zzevi.zzl(uri2);
            return;
        }
        zzawp2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzevj.setMetadata(this.zzadk().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzevj.setMetadata(this.zzadk().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzevj.setMetadata(this.zzadk().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzevf.getCastMediaOptions().getImagePicker() != null ? this.zzevf.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzadk() {
        MediaMetadataCompat mediaMetadataCompat = this.zzevj.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzadl() {
        if (this.zzevf.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzeog, MediaNotificationService.class);
        intent.setPackage(this.zzeog.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzeog.stopService(intent);
    }

    private final void zzadm() {
        if (!this.zzevf.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzeog, ReconnectionService.class);
        intent.setPackage(this.zzeog.getPackageName());
        this.zzeog.stopService(intent);
    }

    static /* synthetic */ void zza(zzawp zzawp2, Bitmap bitmap, int n) {
        zzawp2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzawp zzawp2) {
        return zzawp2.zzepb;
    }
}

