/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzavu;
import com.google.android.gms.internal.zzavy;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzepj;
        private int zzepk;
        private String zzepl;
        private OnOverlayDismissedListener zzepm;
        private boolean zzepn;
        private float zzepo;
        private String zzepp;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzepj = ((MenuItem)zzbp.zzu((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbp.zzu((Object)activity);
            this.zzepj = (View)zzbp.zzu((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzepk = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzepl = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzepl = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzepm = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzepn = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzepo = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzepo = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzepp = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzepp = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzace() {
            return this.zzepj;
        }

        public final OnOverlayDismissedListener zzacf() {
            return this.zzepm;
        }

        public final int zzacg() {
            return this.zzepk;
        }

        public final boolean zzach() {
            return this.zzepn;
        }

        public final String zzaci() {
            return this.zzepl;
        }

        public final String zzacj() {
            return this.zzepp;
        }

        public final float zzack() {
            return this.zzepo;
        }

        public IntroductoryOverlay build() {
            if (zzq.zzale()) {
                return new zzavu(this);
            }
            return new zzavy(this);
        }
    }

    public static final class zza {
        public static void zzbn(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbo(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

