/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawx;

public final class zzaww
extends UIController {
    private final ImageView zzevy;
    private final ImageHints zzeux;
    private final Bitmap zzevz;
    private final ImagePicker zzesg;
    private final zzawe zzewa;

    public zzaww(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzevy = imageView;
        this.zzeux = imageHints;
        this.zzevz = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesg = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzewa = new zzawe(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzewa.zza(new zzawx(this));
        this.zzevy.setImageBitmap(this.zzevz);
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzewa.clear();
        this.zzevy.setImageBitmap(this.zzevz);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    private final void zzadp() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevy.setImageBitmap(this.zzevz);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzaww zzaww2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzaww2.zzesg != null && (webImage = zzaww2.zzesg.onPickImage(mediaInfo.getMetadata(), zzaww2.zzeux)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzevy.setImageBitmap(this.zzevz);
            return;
        }
        this.zzewa.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzaww zzaww2) {
        return zzaww2.zzevy;
    }
}

