/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzaxl;
import com.google.android.gms.internal.zzayn;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbbw;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbbv zzelw = new zzbbv("CastSession");
    private final Context zzerb;
    private final Set<Cast.Listener> zzerq = new HashSet<Cast.Listener>();
    private final zzl zzerr;
    private final CastOptions zzerh;
    private final Cast.CastApi zzers;
    private final zzaxl zzert;
    private final zzayn zzeru;
    private GoogleApiClient zzerv;
    private RemoteMediaClient zzerw;
    private CastDevice zzerx;
    private Cast.ApplicationConnectionResult zzery;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzaxl zzaxl2, zzayn zzayn2) {
        super(context, string2, string3);
        this.zzerb = context.getApplicationContext();
        this.zzerh = castOptions;
        this.zzers = castApi;
        this.zzert = zzaxl2;
        this.zzeru = zzayn2;
        this.zzerr = zzaxj.zza(context, castOptions, this.zzacq(), new zzb(this, null));
    }

    @Override
    protected void onStarting(Bundle bundle) {
        this.zzerx = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void onResuming(Bundle bundle) {
        this.zzerx = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzerr.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerw;
    }

    public CastDevice getCastDevice() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzerx;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            this.zzers.requestStatus(this.zzerv);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.getActiveInputState(this.zzerv);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.getStandbyState(this.zzerv);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.getApplicationMetadata(this.zzerv);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.getApplicationStatus(this.zzerv);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            this.zzers.setVolume(this.zzerv, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.getVolume(this.zzerv);
        }
        return 0.0;
    }

    public final zzayn zzack() {
        return this.zzeru;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            this.zzers.setMute(this.zzerv, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.isMute(this.zzerv);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbq.zzga((String)"Must be called from the main thread.");
        return this.zzery;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            this.zzers.setMessageReceivedCallbacks(this.zzerv, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            this.zzers.removeMessageReceivedCallbacks(this.zzerv, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerv != null) {
            return this.zzers.sendMessage(this.zzerv, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzerq.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzerq.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzerx = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzerx == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzerv != null) {
            this.zzerv.disconnect();
            this.zzerv = null;
        }
        zzelw.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzerx});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzerh;
        CastDevice castDevice = this.zzerx;
        Context context = this.zzerb;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzerv = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzerv.connect();
    }

    private final void zzbg(int n) {
        this.zzeru.zzbj(n);
        if (this.zzerv != null) {
            this.zzerv.disconnect();
            this.zzerv = null;
        }
        this.zzerx = null;
        if (this.zzerw != null) {
            this.zzerw.zzc(null);
            this.zzerw = null;
        }
        this.zzery = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbq.zzga((String)"Must be called from the main thread.");
        if (this.zzerw == null) {
            return 0L;
        }
        return this.zzerw.getStreamDuration() - this.zzerw.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzesa;

        private zzb(CastSession castSession) {
            this.zzesa = castSession;
        }

        @Override
        public final void zzq(String string2, String string3) {
            if (this.zzesa.zzerv != null) {
                this.zzesa.zzers.joinApplication(this.zzesa.zzerv, string2, string3).setResultCallback((ResultCallback)new zza(this.zzesa, "joinApplication"));
            }
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            if (this.zzesa.zzerv != null) {
                this.zzesa.zzers.launchApplication(this.zzesa.zzerv, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzesa, "launchApplication"));
            }
        }

        @Override
        public final void zzfb(String string2) {
            if (this.zzesa.zzerv != null) {
                this.zzesa.zzers.stopApplication(this.zzesa.zzerv, string2);
            }
        }

        @Override
        public final void zzbg(int n) {
            this.zzesa.zzbg(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzerz;
        private /* synthetic */ CastSession zzesa;

        zza(CastSession castSession, String string2) {
            this.zzesa = castSession;
            this.zzerz = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzesa.zzery = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzelw.zzb("%s() -> success result", new Object[]{zza2.zzerz});
                    zza2.zzesa.zzerw = new RemoteMediaClient(new zzbbw(null, zzh.zzalv()), zza2.zzesa.zzers);
                    try {
                        zza2.zzesa.zzerw.zzc(zza2.zzesa.zzerv);
                        zza2.zzesa.zzerw.zzads();
                        zza2.zzesa.zzerw.requestStatus();
                        zza2.zzesa.zzeru.zza(zza2.zzesa.zzerw, zza2.zzesa.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzelw.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzesa.zzerw = null;
                    }
                    zza2.zzesa.zzerr.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzelw.zzb("%s() -> failure result", new Object[]{zza2.zzerz});
                zza2.zzesa.zzerr.zzbh(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzesa;

        private zzc(CastSession castSession) {
            this.zzesa = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzesa.zzbg(n);
            this.zzesa.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzesa.zzerq).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzesa;

        private zzd(CastSession castSession) {
            this.zzesa = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzesa.zzerw != null) {
                    try {
                        this.zzesa.zzerw.zzads();
                        this.zzesa.zzerw.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzelw.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzesa.zzerw = null;
                    }
                }
                this.zzesa.zzerr.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzesa.zzerr.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzesa.zzerr.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzelw.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

