/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdlp;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzete = new Paint();
    private final Paint zzeue = new Paint();
    private final Rect zzetj = new Rect();
    private final int zzeuf;
    private final int zzeug;
    private float zzetf;
    private float zzeuh = 1.0f;
    private float centerX;
    private float centerY;
    private float zzeui;
    private float zzeuj;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzeuf = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzeug = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzete.setAntiAlias(true);
        this.zzete.setStyle(Paint.Style.FILL);
        this.zzeue.setAntiAlias(true);
        this.zzeue.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzete.setColor(-1);
        innerZoneDrawable.zzeue.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzeuj > 0.0f) {
            float f = this.zzetf * this.zzeui;
            this.zzeue.setAlpha((int)((float)this.zzeug * this.zzeuj));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzeue);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzetf * this.zzeuh, this.zzete);
    }

    public void setAlpha(int n) {
        this.zzete.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzete.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzeuh = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzeui = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzeuj = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzetj.set(rect);
        this.centerX = this.zzetj.exactCenterX();
        this.centerY = this.zzetj.exactCenterY();
        this.zzetf = Math.max((float)this.zzeuf, Math.max((float)this.zzetj.width() / 2.0f, (float)this.zzetj.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzadl() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdlp.zzbke());
        return objectAnimator.setDuration(200L);
    }
}

