/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzayb;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayq;

public final class zzayn
implements RemoteMediaClient.Listener {
    private final Context zzerb;
    private final CastOptions zzeyd;
    private final zzayb zzesu;
    private final ComponentName zzeye;
    private final zzayc zzeyf;
    private final zzayc zzeyg;
    private RemoteMediaClient zzerw;
    private CastDevice zzelc;
    private MediaSessionCompat zzeyh;
    private MediaSessionCompat.Callback zzeyi;
    private boolean zzeyj;

    public zzayn(Context context, CastOptions castOptions, zzayb zzayb2) {
        this.zzerb = context;
        this.zzeyd = castOptions;
        this.zzesu = zzayb2;
        this.zzeye = this.zzeyd.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzeyd.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzerb, this.zzeyd.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzeyf = new zzayc(this.zzerb);
        this.zzeyf.zza(new zzayo(this));
        this.zzeyg = new zzayc(this.zzerb);
        this.zzeyg.zza(new zzayp(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.zzeyj || this.zzeyd == null || this.zzeyd.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzerw = remoteMediaClient;
        this.zzerw.addListener(this);
        this.zzelc = castDevice;
        if (!zzq.zzamc()) {
            ((AudioManager)this.zzerb.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzerb, this.zzeyd.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzerb, (int)0, (Intent)intent, (int)0);
        this.zzeyh = new MediaSessionCompat(this.zzerb, "CastMediaSession", componentName, pendingIntent);
        this.zzeyh.setFlags(3);
        this.zza(0, null);
        if (this.zzelc != null && !TextUtils.isEmpty((CharSequence)this.zzelc.getFriendlyName())) {
            this.zzeyh.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzerb.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzelc.getFriendlyName()})).build());
        }
        this.zzeyi = new zzayq(this);
        this.zzeyh.setCallback(this.zzeyi);
        this.zzeyh.setActive(true);
        this.zzesu.setMediaSessionCompat(this.zzeyh);
        this.zzeyj = true;
        this.zzax(false);
    }

    public final void zzbj(int n) {
        if (!this.zzeyj) {
            return;
        }
        this.zzeyj = false;
        if (this.zzerw != null) {
            this.zzerw.removeListener(this);
        }
        if (!zzq.zzamc()) {
            ((AudioManager)this.zzerb.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzesu.setMediaSessionCompat(null);
        if (this.zzeyf != null) {
            this.zzeyf.clear();
        }
        if (this.zzeyg != null) {
            this.zzeyg.clear();
        }
        if (this.zzeyh != null) {
            this.zzeyh.setSessionActivity(null);
            this.zzeyh.setCallback(null);
            this.zzeyh.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzeyh.setActive(false);
            this.zzeyh.release();
            this.zzeyh = null;
        }
        this.zzerw = null;
        this.zzelc = null;
        this.zzeyi = null;
        this.zzaeb();
        if (n == 0) {
            this.zzaec();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzax(boolean bl) {
        int n;
        if (this.zzerw == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzerw.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzerw.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzerw.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzaeb();
            this.zzaec();
            return;
        }
        boolean bl5 = bl;
        zzayn zzayn2 = this;
        if (zzayn2.zzeyd.getCastMediaOptions().getNotificationOptions() != null && zzayn2.zzerw != null) {
            Intent intent = new Intent(zzayn2.zzerb, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzayn2.zzerb.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzayn2.zzerw.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzayn2.zzerw.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzayn2.zzelc);
            zzayn zzayn3 = zzayn2;
            intent.putExtra("extra_media_session_token", zzayn3.zzeyh == null ? null : zzayn3.zzeyh.getSessionToken());
            MediaStatus mediaStatus2 = zzayn2.zzerw.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzayn2.zzerb.startService(intent);
        }
        if (!bl2) {
            zzayn2 = this;
            if (zzayn2.zzeyd.getEnableReconnectionService()) {
                Intent intent = new Intent(zzayn2.zzerb, ReconnectionService.class);
                intent.setPackage(zzayn2.zzerb.getPackageName());
                zzayn2.zzerb.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzeyh.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzeyh.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzeyh.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzayn zzayn2 = this;
        if (zzayn2.zzeye == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzayn2.zzeye);
            pendingIntent = PendingIntent.getActivity((Context)zzayn2.zzerb, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzeyh.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzayn2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzayn2.zzaea().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzayn2.zzeyh.setMetadata(builder.build());
        Uri uri = zzayn2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzayn2.zzeyf.zzl(uri);
        } else {
            zzayn2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzayn2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzayn2.zzeyg.zzl(uri2);
            return;
        }
        zzayn2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzeyh.setMetadata(this.zzaea().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzeyh.setMetadata(this.zzaea().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzeyh.setMetadata(this.zzaea().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzeyd.getCastMediaOptions().getImagePicker() != null ? this.zzeyd.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzaea() {
        MediaMetadataCompat mediaMetadataCompat = this.zzeyh.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzaeb() {
        if (this.zzeyd.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzerb, MediaNotificationService.class);
        intent.setPackage(this.zzerb.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzerb.stopService(intent);
    }

    private final void zzaec() {
        if (!this.zzeyd.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzerb, ReconnectionService.class);
        intent.setPackage(this.zzerb.getPackageName());
        this.zzerb.stopService(intent);
    }

    static /* synthetic */ void zza(zzayn zzayn2, Bitmap bitmap, int n) {
        zzayn2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzayn zzayn2) {
        return zzayn2.zzerw;
    }
}

