/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayv;

public final class zzayu
extends UIController {
    private final ImageView zzeyw;
    private final ImageHints zzexu;
    private final Bitmap zzeyx;
    private final ImagePicker zzeva;
    private final zzayc zzeyy;

    public zzayu(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzeyw = imageView;
        this.zzexu = imageHints;
        this.zzeyx = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzeva = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzeyy = new zzayc(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeyy.zza(new zzayv(this));
        this.zzeyw.setImageBitmap(this.zzeyx);
        this.zzaef();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeyy.clear();
        this.zzeyw.setImageBitmap(this.zzeyx);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaef();
    }

    private final void zzaef() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzeyw.setImageBitmap(this.zzeyx);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzayu zzayu2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzayu2.zzeva != null && (webImage = zzayu2.zzeva.onPickImage(mediaInfo.getMetadata(), zzayu2.zzexu)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzeyw.setImageBitmap(this.zzeyx);
            return;
        }
        this.zzeyy.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzayu zzayu2) {
        return zzayu2.zzeyw;
    }
}

