/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayx;

public final class zzayw
extends UIController {
    private final ImageView zzeyw;
    private final ImageHints zzexu;
    private final Bitmap zzeza;
    private final View zzezb;
    private final ImagePicker zzeva;
    private final zzayc zzeyy;

    public zzayw(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzeyw = imageView;
        this.zzexu = imageHints;
        this.zzeza = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzezb = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzeva = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzeyy = new zzayc(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeyy.zza(new zzayx(this));
        this.zzaeg();
        this.zzaef();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeyy.clear();
        this.zzaeg();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaef();
    }

    private final void zzaef() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzaeg();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzayw zzayw2 = this;
        if ((mediaInfo == null ? null : (uri = zzayw2.zzeva != null && (webImage = zzayw2.zzeva.onPickImage(mediaInfo.getMetadata(), zzayw2.zzexu)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzaeg();
            return;
        }
        this.zzeyy.zzl(uri);
    }

    private final void zzaeg() {
        if (this.zzezb != null) {
            this.zzezb.setVisibility(0);
            this.zzeyw.setVisibility(4);
        }
        if (this.zzeza != null) {
            this.zzeyw.setImageBitmap(this.zzeza);
        }
    }

    static /* synthetic */ View zza(zzayw zzayw2) {
        return zzayw2.zzezb;
    }

    static /* synthetic */ ImageView zzb(zzayw zzayw2) {
        return zzayw2.zzeyw;
    }
}

