/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzazj;

public final class zzazi
extends UIController {
    private final ImageView zzeyw;
    private final View zzezl;
    private final boolean zzezm;
    private final Drawable zzezn;
    private final String zzezo;
    private final Drawable zzezp;
    private final String zzezq;
    private final Drawable zzezr;
    private final String zzezs;
    private final View.OnClickListener zzeyu;

    public zzazi(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzeyw = imageView;
        this.zzezn = drawable2;
        this.zzezp = drawable3;
        this.zzezr = drawable4 != null ? drawable4 : drawable3;
        this.zzezo = context.getString(R.string.cast_play);
        this.zzezq = context.getString(R.string.cast_pause);
        this.zzezs = context.getString(R.string.cast_stop);
        this.zzezl = view;
        this.zzezm = bl;
        this.zzeyu = new zzazj(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeyw.setOnClickListener(this.zzeyu);
        this.zzaef();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeyw.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaef();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzaz(true);
    }

    private final void zzaef() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzeyw.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzezn, this.zzezo);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzezr, this.zzezs);
                return;
            }
            this.zza(this.zzezp, this.zzezq);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzaz(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzaz(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzeyw.setImageDrawable(drawable2);
        this.zzeyw.setContentDescription((CharSequence)string2);
        this.zzeyw.setVisibility(0);
        this.zzeyw.setEnabled(true);
        if (this.zzezl != null) {
            this.zzezl.setVisibility(8);
        }
    }

    private final void zzaz(boolean bl) {
        if (this.zzezl != null) {
            this.zzezl.setVisibility(0);
        }
        this.zzeyw.setVisibility(this.zzezm ? 4 : 0);
        this.zzeyw.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzazi zzazi2) {
        return zzazi2.getRemoteMediaClient();
    }
}

