/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzayv;
import com.google.android.gms.internal.zzazm;
import com.google.android.gms.internal.zzbbz;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbhf;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzbcy zzeom = new zzbcy("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzetu;
    private final Context zzbhi;
    private final zzj zzetv;
    private final SessionManager zzetw;
    private final zze zzetx;
    private final PrecacheManager zzety;
    private final MediaNotificationManager zzetz;
    private final CastOptions zzeua;
    private zzazm zzeub;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (zzetu == null) {
            OptionsProvider optionsProvider = CastContext.zzbu(context.getApplicationContext());
            zzetu = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzetu;
    }

    private static OptionsProvider zzbu(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbhf.zzdb((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzeom.zzc("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        PrecacheManager precacheManager;
        void var7_12;
        this.zzbhi = context.getApplicationContext();
        this.zzeua = castOptions;
        this.zzeub = new zzazm(MediaRouter.getInstance((Context)this.zzbhi));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzayv zzayv2 = new zzayv(this.zzbhi, castOptions, this.zzeub);
        hashMap.put(zzayv2.getCategory(), zzayv2.zzadm());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbq.checkNotNull((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string2 = zzbq.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbq.checkArgument((!hashMap.containsKey(string2) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string2));
                hashMap.put(string2, object2.zzadm());
            }
        }
        this.zzetv = zzayu.zza(this.zzbhi, castOptions, this.zzeub, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzetv.zzada();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzetx = object3 == null ? null : new zze((zzp)object3);
        Object var7_10 = null;
        try {
            zzv zzv2 = this.zzetv.zzacz();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzetw = var7_12 == null ? null : new SessionManager((zzv)var7_12, this.zzbhi);
        this.zzetz = new MediaNotificationManager(this.zzetw);
        if (this.zzetw == null) {
            precacheManager = null;
        } else {
            Context context2 = this.zzbhi;
            PrecacheManager precacheManager2 = new PrecacheManager(this.zzeua, this.zzetw, new zzbbz(context2));
            precacheManager = precacheManager2;
        }
        this.zzety = precacheManager;
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeua;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzetw;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzetv.zzacy());
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzetw.getCastState();
    }

    public final PrecacheManager getPrecacheManager() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzety;
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzetv.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzetz;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbq.zzge((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)appVisibilityListener);
        try {
            this.zzetv.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzetv.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbq.zzge((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)castStateListener);
        this.zzetw.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzetw.removeCastStateListener(castStateListener);
    }

    public final zze zzacu() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzetx;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (zzq.zzami()) {
            return false;
        }
        CastSession castSession = this.zzetw.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzeom.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zzacv() {
        try {
            return this.zzetv.zzadb();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

