/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzban;
import com.google.android.gms.internal.zzbar;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity zza;
        private final View zzb;
        private int zzc;
        private String zzd;
        private OnOverlayDismissedListener zze;
        private boolean zzf;
        private float zzg;
        private String zzh;

        public Builder(Activity activity, MenuItem menuItem) {
            this.zza = (Activity)zzbq.zza((Object)activity);
            this.zzb = ((MenuItem)zzbq.zza((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.zza = (Activity)zzbq.zza((Object)activity);
            this.zzb = (View)zzbq.zza((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzc = this.zza.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzd = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzd = this.zza.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zze = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzf = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzg = this.zza.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzg = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzh = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzh = this.zza.getResources().getString(n);
            return this;
        }

        @Hide
        public final Activity zza() {
            return this.zza;
        }

        @Hide
        public final View zzb() {
            return this.zzb;
        }

        @Hide
        public final OnOverlayDismissedListener zzc() {
            return this.zze;
        }

        @Hide
        public final int zzd() {
            return this.zzc;
        }

        @Hide
        public final boolean zze() {
            return this.zzf;
        }

        @Hide
        public final String zzf() {
            return this.zzd;
        }

        @Hide
        public final String zzg() {
            return this.zzh;
        }

        @Hide
        public final float zzh() {
            return this.zzg;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzb()) {
                return new zzban(this);
            }
            return new zzbar(this);
        }
    }

    @Hide
    public static final class zza {
        public static void zza(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzb(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

