/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdny;

@Hide
class InnerZoneDrawable
extends Drawable {
    private final Paint zza = new Paint();
    private final Paint zzb = new Paint();
    private final Rect zzc = new Rect();
    private final int zzd;
    private final int zze;
    private float zzf;
    private float zzg = 1.0f;
    private float zzh;
    private float zzi;
    private float zzj;
    private float zzk;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzd = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zze = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zza.setAntiAlias(true);
        this.zza.setStyle(Paint.Style.FILL);
        this.zzb.setAntiAlias(true);
        this.zzb.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zza.setColor(-1);
        innerZoneDrawable.zzb.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzk > 0.0f) {
            float f = this.zzf * this.zzj;
            this.zzb.setAlpha((int)((float)this.zze * this.zzk));
            canvas.drawCircle(this.zzh, this.zzi, f, this.zzb);
        }
        canvas.drawCircle(this.zzh, this.zzi, this.zzf * this.zzg, this.zza);
    }

    public void setAlpha(int n) {
        this.zza.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zza.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzg = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzj = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzk = f;
        this.invalidateSelf();
    }

    public final void zza(Rect rect) {
        this.zzc.set(rect);
        this.zzh = this.zzc.exactCenterX();
        this.zzi = this.zzc.exactCenterY();
        this.zzf = Math.max((float)this.zzd, Math.max((float)this.zzc.width() / 2.0f, (float)this.zzc.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zza() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zzb());
        return objectAnimator.setDuration(200L);
    }
}

