/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.InnerZoneDrawable;
import com.google.android.gms.cast.framework.internal.featurehighlight.OuterHighlightDrawable;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzf;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzg;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzh;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzi;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzj;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzdnp;
import com.google.android.gms.internal.zzdny;
import com.google.android.gms.internal.zzdog;

@Hide
public final class zza
extends ViewGroup {
    private final int[] zza = new int[2];
    private final Rect zzb = new Rect();
    private final Rect zzc = new Rect();
    private final OuterHighlightDrawable zzd;
    private final InnerZoneDrawable zze;
    private zzi zzf;
    private View zzg;
    @Nullable
    private View zzh;
    @Nullable
    private Animator zzi;
    private final zzj zzj;
    private final GestureDetectorCompat zzk;
    @Nullable
    private GestureDetectorCompat zzl;
    private zzh zzm;
    private boolean zzn;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.zze = new InnerZoneDrawable(context);
        this.zze.setCallback((Drawable.Callback)this);
        this.zzd = new OuterHighlightDrawable(context);
        this.zzd.setCallback((Drawable.Callback)this);
        this.zzj = new zzj(this);
        zzb zzb2 = new zzb(this);
        this.zzk = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)zzb2);
        this.zzk.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public final void zza(zzi zzi2) {
        this.zzf = (zzi)zzdog.zza((Object)zzi2);
        this.addView(zzi2.asView(), 0);
    }

    public final void zza(View view, @Nullable View view2, boolean bl, zzh zzh2) {
        this.zzg = (View)zzdog.zza((Object)view);
        this.zzh = null;
        this.zzm = (zzh)zzdog.zza((Object)zzh2);
        zzc zzc2 = new zzc(this, view, true, zzh2);
        this.zzl = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)zzc2);
        this.zzl.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(com.google.android.gms.cast.framework.internal.featurehighlight.zza.resolveSize((int)n3, (int)n), com.google.android.gms.cast.framework.internal.featurehighlight.zza.resolveSize((int)n4, (int)n2));
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.zzg == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.zzg.getParent() != null) {
            View view = this.zzg;
            int[] nArray = this.zza;
            zza zza2 = this;
            zza2.getLocationInWindow(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            view.getLocationInWindow(nArray);
            nArray[0] = nArray[0] - n5;
            nArray[1] = nArray[1] - n6;
        }
        this.zzb.set(this.zza[0], this.zza[1], this.zza[0] + this.zzg.getWidth(), this.zza[1] + this.zzg.getHeight());
        this.zzc.set(n, n2, n3, n4);
        this.zzd.setBounds(this.zzc);
        this.zze.setBounds(this.zzc);
        this.zzj.zza(this.zzb, this.zzc);
    }

    protected final void onDraw(Canvas canvas) {
        canvas.save();
        this.zzd.draw(canvas);
        this.zze.draw(canvas);
        if (this.zzg != null) {
            if (this.zzg.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.zzg.getWidth(), (int)this.zzg.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.zzg.draw(canvas2);
                int n = this.zzd.zza();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.zzb.left, (float)this.zzb.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    protected final boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.zzd || drawable == this.zze || drawable == null;
    }

    public final void zza(@Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new zzd(this, null));
    }

    public final void zza() {
        if (this.zzg == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzf.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zza());
        float f = zza2.zzb.exactCenterX() - zza2.zzd.zzb();
        float f2 = zza2.zzb.exactCenterY() - zza2.zzd.zzc();
        Animator animator = zza2.zzd.zzb(f, f2);
        InnerZoneDrawable innerZoneDrawable = zza2.zze;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, 255});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)innerZoneDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdny.zza());
        Animator animator2 = objectAnimator2.setDuration(350L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zze(zza2));
        this.zza((Animator)animatorSet);
    }

    public final void zzb(@Nullable Runnable runnable) {
        float f;
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzf.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zzb());
        float f2 = zza2.zzb.exactCenterX() - zza2.zzd.zzb();
        float f3 = f = zza2.zzb.exactCenterY() - zza2.zzd.zzc();
        float f4 = f2;
        OuterHighlightDrawable outerHighlightDrawable = zza2.zzd;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, f4});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f, f3});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)outerHighlightDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder3, propertyValuesHolder4, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdny.zzb());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zze.zza();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzg(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zzc(@Nullable Runnable runnable) {
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzf.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zzb());
        OuterHighlightDrawable outerHighlightDrawable = zza2.zzd;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.125f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)outerHighlightDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdny.zzb());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zze.zza();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzf(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zza(@ColorInt int n) {
        this.zzd.zza(n);
    }

    final View zzb() {
        return this.zzf.asView();
    }

    final OuterHighlightDrawable zzc() {
        return this.zzd;
    }

    final InnerZoneDrawable zzd() {
        return this.zze;
    }

    private final void zza(Animator animator) {
        if (this.zzi != null) {
            this.zzi.cancel();
        }
        this.zzi = animator;
        this.zzi.start();
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.zzn = this.zzb.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.zzn) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.zzl != null) {
                this.zzl.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.zzg.getParent() != null) {
                this.zzg.onTouchEvent(motionEvent2);
            }
        } else {
            this.zzk.onTouchEvent(motionEvent);
        }
        return true;
    }

    private final boolean zza(float f, float f2) {
        return this.zzc.contains(Math.round(f), Math.round(f2));
    }

    private final Animator zze() {
        InnerZoneDrawable innerZoneDrawable = this.zze;
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)innerZoneDrawable), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)innerZoneDrawable), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)innerZoneDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzdny.zzc());
        animatorSet.setStartDelay(500L);
        zzdnp.zza((Animator)animatorSet, -1, null);
        return animatorSet;
    }

    static /* synthetic */ boolean zza(zza zza2, float f, float f2) {
        return zza2.zza(f, f2);
    }

    static /* synthetic */ OuterHighlightDrawable zza(zza zza2) {
        return zza2.zzd;
    }

    static /* synthetic */ zzh zzb(zza zza2) {
        return zza2.zzm;
    }

    static /* synthetic */ Animator zza(zza zza2, Animator animator) {
        zza2.zzi = animator;
        return zza2.zzi;
    }

    static /* synthetic */ Animator zzc(zza zza2) {
        return zza2.zze();
    }

    static /* synthetic */ Animator zzd(zza zza2) {
        return zza2.zzi;
    }
}

