/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.uicontroller.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.zzc;
import com.google.android.gms.cast.framework.media.uicontroller.zzd;
import com.google.android.gms.cast.framework.media.uicontroller.zze;
import com.google.android.gms.cast.framework.media.uicontroller.zzf;
import com.google.android.gms.cast.framework.media.uicontroller.zzg;
import com.google.android.gms.cast.framework.media.uicontroller.zzh;
import com.google.android.gms.cast.framework.media.uicontroller.zzi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbbn;
import com.google.android.gms.internal.zzbbo;
import com.google.android.gms.internal.zzbbq;
import com.google.android.gms.internal.zzbbs;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbbx;
import com.google.android.gms.internal.zzbby;
import com.google.android.gms.internal.zzbca;
import com.google.android.gms.internal.zzbcb;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcd;
import com.google.android.gms.internal.zzbce;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbcg;
import com.google.android.gms.internal.zzbch;
import com.google.android.gms.internal.zzbci;
import com.google.android.gms.internal.zzbcj;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbei;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private static final zzbei zza = new zzbei("UIMediaController");
    private final Activity zzb;
    private final SessionManager zzc;
    private final Map<View, List<UIController>> zzd = new HashMap<View, List<UIController>>();
    private final Set<zzbci> zze = new HashSet<zzbci>();
    private RemoteMediaClient.Listener zzf;
    private RemoteMediaClient zzg;

    public UIMediaController(Activity activity) {
        this.zzb = activity;
        CastContext castContext = CastContext.zza((Context)activity);
        SessionManager sessionManager = this.zzc = castContext != null ? castContext.getSessionManager() : null;
        if (this.zzc != null) {
            SessionManager sessionManager2 = CastContext.getSharedInstance((Context)activity).getSessionManager();
            sessionManager2.addSessionManagerListener(this, CastSession.class);
            this.zza(sessionManager2.getCurrentCastSession());
        }
    }

    public boolean isActive() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzg != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzg;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zzf = listener;
    }

    public void dispose() {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza();
        this.zzd.clear();
        if (this.zzc != null) {
            this.zzc.removeSessionManagerListener(this, CastSession.class);
        }
        this.zzf = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbq.zzb((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zza(this));
        this.zza((View)imageView, new zzbca(imageView, (Context)this.zzb, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzb(this));
        this.zza(view, new zzbce(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzc(this));
        this.zza(view, new zzbcf(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzd(this, l));
        this.zza(view, new zzbcd(view));
    }

    public void bindViewToRewind(View view, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zze(this, l));
        this.zza(view, new zzbcd(view));
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza(view, new zzbbv(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzbcb(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new zzf(this));
        this.zza((View)seekBar, new zzbcc(seekBar, l));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        zzbci zzbci2 = new zzbci(textView, l, this.zzb.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zze.add(zzbci2);
        }
        this.zza((View)textView, zzbci2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbch(textView, this.zzb.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbch(textView, this.zzb.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzg(this));
        this.zza(view, new zzbbs(view));
    }

    public void bindViewToClosedCaption(View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzh(this));
        this.zza(view, new zzbbn(view, (Context)this.zzb));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbq.zzb((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zzi(this));
        this.zza((View)imageView, new zzbby(imageView, (Context)this.zzb));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbbx(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.zzb, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.zzb, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.zzb, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbq(imageView, (Context)this.zzb, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza(view, new zzbck(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbbw(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbo(imageView, (Context)this.zzb, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbbo(imageView, (Context)this.zzb, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza(view, new zzbcj(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbcg(textView));
    }

    protected void onMuteToggleClicked(ImageView imageView) {
        CastSession castSession = CastContext.getSharedInstance(this.zzb.getApplicationContext()).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return;
        }
        try {
            boolean bl = castSession.isMute();
            castSession.setMute(!bl);
            return;
        }
        catch (IOException | IllegalArgumentException exception) {
            zza.zzd("Unable to call CastSession.setMute(boolean).", new Object[]{exception});
            return;
        }
    }

    protected void onPlayPauseToggleClicked(ImageView imageView) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.togglePlayback();
        }
    }

    protected void onSeekBarStopTrackingTouch(SeekBar seekBar) {
        if (this.zzd.containsKey(seekBar)) {
            for (UIController uIController : this.zzd.get(seekBar)) {
                if (!(uIController instanceof zzbcc)) continue;
                ((zzbcc)uIController).zza(true);
            }
        }
        Object object = this.zze.iterator();
        while (object.hasNext()) {
            ((zzbci)object.next()).zza(true);
        }
        object = this.getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            ((RemoteMediaClient)object).seek(seekBar.getProgress());
        }
    }

    protected void onSeekBarStartTrackingTouch(SeekBar seekBar) {
        if (this.zzd.containsKey(seekBar)) {
            for (UIController uIController : this.zzd.get(seekBar)) {
                if (!(uIController instanceof zzbcc)) continue;
                ((zzbcc)uIController).zza(false);
            }
        }
        Iterator<UIController> iterator = this.zze.iterator();
        while (iterator.hasNext()) {
            ((zzbci)iterator.next()).zza(false);
        }
    }

    protected void onSeekBarProgressChanged(SeekBar seekBar, int n, boolean bl) {
        if (bl) {
            Iterator<zzbci> iterator = this.zze.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(n);
            }
        }
    }

    protected void onClosedCaptionClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (this.zzb instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)this.zzb;
            FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
            Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
            if (fragment != null) {
                fragmentTransaction.remove(fragment);
            }
            fragmentTransaction.addToBackStack(null);
            MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
            long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
            TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
            if (tracksChooserDialogFragment != null) {
                tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
            }
        }
    }

    protected void onForwardClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() + l);
        }
    }

    protected void onLaunchExpandedControllerClicked(View view) {
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance((Context)this.zzb).getCastOptions().getCastMediaOptions();
        ComponentName componentName = new ComponentName(this.zzb.getApplicationContext(), castMediaOptions.getExpandedControllerActivityClassName());
        Intent intent = new Intent();
        intent.setComponent(componentName);
        this.zzb.startActivity(intent);
    }

    protected void onRewindClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() - l);
        }
    }

    protected void onSkipNextClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queueNext(null);
        }
    }

    protected void onSkipPrevClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queuePrev(null);
        }
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zza();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zza();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zza();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzb();
        if (this.zzf != null) {
            this.zzf.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzb();
        if (this.zzf != null) {
            this.zzf.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzb();
        if (this.zzf != null) {
            this.zzf.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzb();
        if (this.zzf != null) {
            this.zzf.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzb();
        if (this.zzf != null) {
            this.zzf.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzd.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzf != null) {
            this.zzf.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzg = castSession.getRemoteMediaClient();
        if (this.zzg != null) {
            this.zzg.addListener(this);
            Iterator<List<UIController>> iterator = this.zzd.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzb();
        }
    }

    private final void zza() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzd.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzg.removeListener(this);
        this.zzg = null;
    }

    private final void zza(View view, UIController uIController) {
        if (this.zzc == null) {
            return;
        }
        List<UIController> list = this.zzd.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzd.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzc.getCurrentCastSession());
            this.zzb();
        }
    }

    private final void zzb() {
        Iterator<List<UIController>> iterator = this.zzd.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }
}

