/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbj;
import com.google.android.gms.internal.zzbbk;
import com.google.android.gms.internal.zzbbl;

@Hide
public final class zzbbi
implements RemoteMediaClient.Listener {
    private final Context zza;
    private final CastOptions zzb;
    private final zzbaw zzc;
    private final ComponentName zzd;
    private final zzbax zze;
    private final zzbax zzf;
    private RemoteMediaClient zzg;
    private CastDevice zzh;
    private MediaSessionCompat zzi;
    private MediaSessionCompat.Callback zzj;
    private boolean zzk;

    public zzbbi(Context context, CastOptions castOptions, zzbaw zzbaw2) {
        this.zza = context;
        this.zzb = castOptions;
        this.zzc = zzbaw2;
        this.zzd = this.zzb.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzb.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zza, this.zzb.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zze = new zzbax(this.zza);
        this.zze.zza(new zzbbj(this));
        this.zzf = new zzbax(this.zza);
        this.zzf.zza(new zzbbk(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.zzk || this.zzb == null || this.zzb.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzg = remoteMediaClient;
        this.zzg.addListener(this);
        this.zzh = castDevice;
        if (!zzs.zzg()) {
            ((AudioManager)this.zza.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zza, this.zzb.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zza, (int)0, (Intent)intent, (int)0);
        this.zzi = new MediaSessionCompat(this.zza, "CastMediaSession", componentName, pendingIntent);
        this.zzi.setFlags(3);
        this.zza(0, null);
        if (this.zzh != null && !TextUtils.isEmpty((CharSequence)this.zzh.getFriendlyName())) {
            this.zzi.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zza.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzh.getFriendlyName()})).build());
        }
        this.zzj = new zzbbl(this);
        this.zzi.setCallback(this.zzj);
        this.zzi.setActive(true);
        this.zzc.zza(this.zzi);
        this.zzk = true;
        this.zza(false);
    }

    public final void zza(int n) {
        if (!this.zzk) {
            return;
        }
        this.zzk = false;
        if (this.zzg != null) {
            this.zzg.removeListener(this);
        }
        if (!zzs.zzg()) {
            ((AudioManager)this.zza.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzc.zza((MediaSessionCompat)null);
        if (this.zze != null) {
            this.zze.zza();
        }
        if (this.zzf != null) {
            this.zzf.zza();
        }
        if (this.zzi != null) {
            this.zzi.setSessionActivity(null);
            this.zzi.setCallback(null);
            this.zzi.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzi.setActive(false);
            this.zzi.release();
            this.zzi = null;
        }
        this.zzg = null;
        this.zzh = null;
        this.zzj = null;
        this.zzb();
        if (n == 0) {
            this.zzc();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zza(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zza(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zza(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zza(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zza(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zza(boolean bl) {
        int n;
        if (this.zzg == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzg.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzg.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzg.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzb();
            this.zzc();
            return;
        }
        boolean bl5 = bl;
        zzbbi zzbbi2 = this;
        if (zzbbi2.zzb.getCastMediaOptions().getNotificationOptions() != null && zzbbi2.zzg != null) {
            Intent intent = new Intent(zzbbi2.zza, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzbbi2.zza.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzbbi2.zzg.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzbbi2.zzg.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzbbi2.zzh);
            zzbbi zzbbi3 = zzbbi2;
            intent.putExtra("extra_media_session_token", zzbbi3.zzi == null ? null : zzbbi3.zzi.getSessionToken());
            MediaStatus mediaStatus2 = zzbbi2.zzg.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzbbi2.zza.startService(intent);
        }
        if (!bl2) {
            zzbbi2 = this;
            if (zzbbi2.zzb.getEnableReconnectionService()) {
                Intent intent = new Intent(zzbbi2.zza, ReconnectionService.class);
                intent.setPackage(zzbbi2.zza.getPackageName());
                zzbbi2.zza.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzi.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzi.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzi.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzbbi zzbbi2 = this;
        if (zzbbi2.zzd == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzbbi2.zzd);
            pendingIntent = PendingIntent.getActivity((Context)zzbbi2.zza, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzi.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzbbi2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzbbi2.zza().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzbbi2.zzi.setMetadata(builder.build());
        Uri uri = zzbbi2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzbbi2.zze.zza(uri);
        } else {
            zzbbi2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzbbi2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzbbi2.zzf.zza(uri2);
            return;
        }
        zzbbi2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzi.setMetadata(this.zza().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzi.setMetadata(this.zza().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzi.setMetadata(this.zza().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzb.getCastMediaOptions().getImagePicker() != null ? this.zzb.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zza() {
        MediaMetadataCompat mediaMetadataCompat = this.zzi.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzb() {
        if (this.zzb.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zza, MediaNotificationService.class);
        intent.setPackage(this.zza.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zza.stopService(intent);
    }

    private final void zzc() {
        if (!this.zzb.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zza, ReconnectionService.class);
        intent.setPackage(this.zza.getPackageName());
        this.zza.stopService(intent);
    }

    static /* synthetic */ void zza(zzbbi zzbbi2, Bitmap bitmap, int n) {
        zzbbi2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzbbi zzbbi2) {
        return zzbbi2.zzg;
    }
}

