/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbp;

@Hide
public final class zzbbo
extends UIController {
    private final ImageView zzfhq;
    private final ImageHints zzfgq;
    private final Bitmap zzfhr;
    private final ImagePicker zzfdu;
    private final zzbax zzfhs;

    public zzbbo(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        CastMediaOptions castMediaOptions;
        this.zzfhq = imageView;
        this.zzfgq = imageHints;
        this.zzfhr = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastContext castContext = CastContext.zzbu(context);
        this.zzfdu = castContext != null ? ((castMediaOptions = castContext.getCastOptions().getCastMediaOptions()) != null ? castMediaOptions.getImagePicker() : null) : null;
        this.zzfhs = new zzbax(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzfhs.zza(new zzbbp(this));
        this.zzfhq.setImageBitmap(this.zzfhr);
        this.zzafy();
    }

    @Override
    public final void onSessionEnded() {
        this.zzfhs.clear();
        this.zzfhq.setImageBitmap(this.zzfhr);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzafy();
    }

    private final void zzafy() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzfhq.setImageBitmap(this.zzfhr);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzbbo zzbbo2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzbbo2.zzfdu != null && (webImage = zzbbo2.zzfdu.onPickImage(mediaInfo.getMetadata(), zzbbo2.zzfgq)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzfhq.setImageBitmap(this.zzfhr);
            return;
        }
        this.zzfhs.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzbbo zzbbo2) {
        return zzbbo2.zzfhq;
    }
}

