/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznz;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzm jr = new zzm("CastSession");
    private final Context zzbxe;
    private final Set<Cast.Listener> jG = new HashSet<Cast.Listener>();
    private final zzh jH;
    private final Cast.CastApi jI;
    private final zzno jJ;
    private final zznz jK;
    private GoogleApiClient hb;
    private RemoteMediaClient jL;
    private CastDevice jM;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzno zzno2, zznz zznz2) {
        super(context, string2, string3);
        this.zzbxe = context.getApplicationContext();
        this.jI = castApi;
        this.jJ = zzno2;
        this.jK = zznz2;
        this.jH = zznm.zza(context, castOptions, this.zzaiu(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.jH.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.jL;
    }

    public CastDevice getCastDevice() {
        return this.jM;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        if (this.hb != null) {
            this.jI.requestStatus(this.hb);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        return this.hb != null ? this.jI.getActiveInputState(this.hb) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        return this.hb != null ? this.jI.getStandbyState(this.hb) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        return this.hb != null ? this.jI.getApplicationMetadata(this.hb) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        return this.hb != null ? this.jI.getApplicationStatus(this.hb) : null;
    }

    public void setVolume(double d) throws IOException {
        if (this.hb != null) {
            this.jI.setVolume(this.hb, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        return this.hb != null ? this.jI.getVolume(this.hb) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        if (this.hb != null) {
            this.jI.setMute(this.hb, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        return this.hb != null ? this.jI.isMute(this.hb) : false;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        if (this.hb != null) {
            this.jI.setMessageReceivedCallbacks(this.hb, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        if (this.hb != null) {
            this.jI.removeMessageReceivedCallbacks(this.hb, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        return this.hb != null ? this.jI.sendMessage(this.hb, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.jG.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.jG.remove(listener);
        }
    }

    private void zzj(Bundle bundle) {
        this.jM = CastDevice.getFromBundle((Bundle)bundle);
        if (this.jM == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.hb != null) {
            this.hb.disconnect();
            this.hb = null;
        }
        jr.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.jM});
        zzd zzd2 = new zzd();
        this.hb = this.jJ.zza(this.zzbxe, this.jM, new zzc(), zzd2, zzd2);
        this.hb.connect();
    }

    private void zzeh(int n) {
        this.jK.zzem(n);
        if (this.hb != null) {
            this.hb.disconnect();
            this.hb = null;
        }
        this.jM = null;
        if (this.jL != null) {
            try {
                this.jL.zzd(null);
            }
            catch (IOException iOException) {
                jr.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.jL = null;
        }
    }

    @Override
    public long getSessionRemainingTimeMs() {
        if (this.jL == null) {
            return 0L;
        }
        return this.jL.getStreamDuration() - this.jL.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzaih() {
            return 9256208;
        }

        @Override
        public void zzz(String string, String string2) {
            CastSession.this.jI.joinApplication(CastSession.this.hb, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.jI.launchApplication(CastSession.this.hb, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzge(String string) {
            CastSession.this.jI.stopApplication(CastSession.this.hb, string);
        }

        @Override
        public void zzeh(int n) {
            CastSession.this.zzeh(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String jN;

        zza(String string) {
            this.jN = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        jr.zzb("%s() -> success result", new Object[]{this.jN});
                        CastSession.this.jL = new RemoteMediaClient(new zzn(null), CastSession.this.jI);
                        try {
                            CastSession.this.jL.zzd(CastSession.this.hb);
                            CastSession.this.jL.requestStatus();
                            CastSession.this.jK.zza(CastSession.this.jL, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            jr.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.jL = null;
                        }
                        CastSession.this.jH.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    jr.zzb("%s() -> failure result", new Object[]{this.jN});
                    CastSession.this.jH.zzei(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzeh(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.jG);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                CastSession.this.jH.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.jH.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.jH.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

