/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.zzd;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class NotificationOptions
extends AbstractSafeParcelable {
    public static final long SKIP_STEP_TEN_SECONDS_IN_MS = 10000L;
    public static final long SKIP_STEP_THIRTY_SECONDS_IN_MS = 30000L;
    private static final List<String> lr = Arrays.asList("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK", "com.google.android.gms.cast.framework.action.STOP_CASTING");
    private static final int[] ls = new int[]{0, 1};
    public static final Parcelable.Creator<NotificationOptions> CREATOR = new zzd();
    private final int mVersionCode;
    private final List<String> lt;
    private final int[] lu;
    private final long lv;
    private final String lw;
    private final int lx;
    private final int ly;
    private final int lz;
    private final int lA;
    private final int lB;
    private final int lC;
    private final int lD;
    private final int lE;
    private final int lF;
    private final int lG;
    private final int lH;
    private final int lI;
    private final int lJ;
    private final int lK;
    private final int lL;
    private final int lM;
    private final int lN;
    private final int lO;
    private final int lP;
    private final int lQ;
    private final int lR;
    private final int lS;
    private final int lT;
    private final int lU;
    private final int lV;
    private final int lW;
    private final int lX;

    public NotificationOptions(int n, List<String> list, int[] nArray, long l, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28) {
        this.mVersionCode = n;
        this.lt = list != null ? new ArrayList<String>(list) : null;
        this.lu = (int[])(nArray != null ? Arrays.copyOf(nArray, nArray.length) : null);
        this.lv = l;
        this.lw = string2;
        this.lx = n2;
        this.ly = n3;
        this.lz = n4;
        this.lA = n5;
        this.lB = n6;
        this.lC = n7;
        this.lD = n8;
        this.lE = n9;
        this.lF = n10;
        this.lG = n11;
        this.lH = n12;
        this.lI = n13;
        this.lJ = n14;
        this.lK = n15;
        this.lL = n16;
        this.lM = n17;
        this.lN = n18;
        this.lO = n19;
        this.lP = n20;
        this.lQ = n21;
        this.lR = n22;
        this.lS = n23;
        this.lT = n24;
        this.lU = n25;
        this.lV = n26;
        this.lW = n27;
        this.lX = n28;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public List<String> getActions() {
        return this.lt;
    }

    public int[] getCompatActionIndices() {
        return Arrays.copyOf(this.lu, this.lu.length);
    }

    public long getSkipStepMs() {
        return this.lv;
    }

    public String getTargetActivityClassName() {
        return this.lw;
    }

    public int getSmallIconDrawableResId() {
        return this.lx;
    }

    public int getStopLiveStreamDrawableResId() {
        return this.ly;
    }

    public int getPauseDrawableResId() {
        return this.lz;
    }

    public int getPlayDrawableResId() {
        return this.lA;
    }

    public int getSkipNextDrawableResId() {
        return this.lB;
    }

    public int getSkipPrevDrawableResId() {
        return this.lC;
    }

    public int getForwardDrawableResId() {
        return this.lD;
    }

    public int getForward10DrawableResId() {
        return this.lE;
    }

    public int getForward30DrawableResId() {
        return this.lF;
    }

    public int getRewindDrawableResId() {
        return this.lG;
    }

    public int getRewind10DrawableResId() {
        return this.lH;
    }

    public int getRewind30DrawableResId() {
        return this.lI;
    }

    public int getDisconnectDrawableResId() {
        return this.lJ;
    }

    public int zzakb() {
        return this.lK;
    }

    public int zzakc() {
        return this.lL;
    }

    public int zzakd() {
        return this.lM;
    }

    public int zzake() {
        return this.lN;
    }

    public int zzakf() {
        return this.lO;
    }

    public int zzakg() {
        return this.lP;
    }

    public int zzakh() {
        return this.lQ;
    }

    public int zzaki() {
        return this.lR;
    }

    public int zzakj() {
        return this.lS;
    }

    public int zzakk() {
        return this.lT;
    }

    public int zzakl() {
        return this.lU;
    }

    public int zzakm() {
        return this.lV;
    }

    public int zzakn() {
        return this.lW;
    }

    public int zzako() {
        return this.lX;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NotificationOptions(actions=%s, compatActionIndices=%s, skipStepMs=%s, targetActivityClassName=%s)", this.lt, Arrays.toString(this.lu), this.lv, this.lw);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NotificationOptions)) {
            return false;
        }
        NotificationOptions notificationOptions = (NotificationOptions)((Object)object);
        return zzf.zza(this.lt, notificationOptions.lt) && Arrays.equals(this.lu, notificationOptions.lu) && this.lv == notificationOptions.lv && zzf.zza((Object)this.lw, (Object)notificationOptions.lw);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.lt, Arrays.hashCode(this.lu), this.lv, this.lw});
    }

    public static final class Builder {
        private String lw;
        private List<String> lt = NotificationOptions.zzakp();
        private int[] lu = NotificationOptions.access$100();
        private long lv = 10000L;

        public Builder setActions(List<String> list, int[] nArray) {
            if (list == null && nArray != null) {
                throw new IllegalArgumentException("When setting actions to null, you must also set compatActionIndices to null.");
            }
            if (list != null && nArray == null) {
                throw new IllegalArgumentException("When setting compatActionIndices to null, you must also set actions to null.");
            }
            if (list != null && nArray != null) {
                int n = list.size();
                if (nArray.length > n) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid number of compat actions: %d > %d.", nArray.length, n));
                }
                for (int n2 : nArray) {
                    if (n2 >= 0 && n2 < n) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Index %d in compatActionIndices out of range: [0, %d]", n2, n - 1));
                }
                this.lt = new ArrayList<String>(list);
                this.lu = Arrays.copyOf(nArray, nArray.length);
            } else {
                this.lt = lr;
                this.lu = ls;
            }
            return this;
        }

        public Builder setSkipStepMs(long l) {
            zzab.zzb((l > 0L ? 1 : 0) != 0, (Object)"skipStepMs must be positive.");
            this.lv = l;
            return this;
        }

        public Builder setTargetActivityClassName(String string2) {
            this.lw = string2;
            return this;
        }

        public NotificationOptions build() {
            return new NotificationOptions(1, this.lt, this.lu, this.lv, this.lw, R.drawable.cast_ic_notification_small_icon, R.drawable.cast_ic_notification_stop_live_stream, R.drawable.cast_ic_notification_pause, R.drawable.cast_ic_notification_play, R.drawable.cast_ic_notification_skip_next, R.drawable.cast_ic_notification_skip_prev, R.drawable.cast_ic_notification_forward, R.drawable.cast_ic_notification_forward10, R.drawable.cast_ic_notification_forward30, R.drawable.cast_ic_notification_rewind, R.drawable.cast_ic_notification_rewind10, R.drawable.cast_ic_notification_rewind30, R.drawable.cast_ic_notification_disconnect, R.dimen.cast_notification_image_size, R.string.cast_casting_to_device, R.string.cast_stop_live_stream, R.string.cast_pause, R.string.cast_play, R.string.cast_skip_next, R.string.cast_skip_prev, R.string.cast_forward, R.string.cast_forward_10, R.string.cast_forward_30, R.string.cast_rewind, R.string.cast_rewind_10, R.string.cast_rewind_30, R.string.cast_disconnect);
        }
    }
}

