/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzos;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager jv;
    private final Map<View, zzoq> mE = new HashMap<View, zzoq>();
    private final Set<zzop> mF = new HashSet<zzop>();
    private RemoteMediaClient.Listener mG;
    private RemoteMediaClient jL;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.jv = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.jv.addSessionManagerListener(this, CastSession.class);
        this.zza(this.jv.getCurrentCastSession());
    }

    public boolean isActive() {
        return this.jL != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.jL;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        this.mG = listener;
    }

    public void dispose() {
        this.zzald();
        this.mE.clear();
        this.jv.removeSessionManagerListener(this, CastSession.class);
        this.mG = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zza((View)imageView, new zzoi(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        this.zza(view, new zzom(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        this.zza(view, new zzon(view, n));
    }

    public void bindViewToForward(View view, long l) {
        this.zza(view, new zzol(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        this.zza(view, new zzoe(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        this.zza((View)progressBar, new zzoj(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzop zzop2 : UIMediaController.this.mF) {
                        zzop2.onProgressUpdated(n, 0L);
                    }
                    RemoteMediaClient remoteMediaClient = UIMediaController.this.getRemoteMediaClient();
                    if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
                        remoteMediaClient.seek(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzok(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzop zzop2 = new zzop(textView, l);
        if (bl) {
            this.mF.add(zzop2);
        }
        this.zza((View)textView, zzop2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        this.zza((View)textView, new zzoo(textView));
    }

    public void bindViewToLaunchExpandedController(View view) {
        this.zza(view, new zzod(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        this.zza(view, new zzoa(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        this.zza((View)imageView, new zzoh(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzog(textView, list));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzoc(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        this.zza(view, new zzos(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzof(textView, list));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzob(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        this.zza(view, new zzor(view, n));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzald();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzald();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzald();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzale();
        if (this.mG != null) {
            this.mG.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzale();
        if (this.mG != null) {
            this.mG.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzale();
        if (this.mG != null) {
            this.mG.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzale();
        if (this.mG != null) {
            this.mG.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (zzoq zzoq2 : this.mE.values()) {
            zzoq2.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.jL = castSession.getRemoteMediaClient();
        if (this.jL != null) {
            this.jL.addListener(this);
            for (zzoq zzoq2 : this.mE.values()) {
                zzoq2.zzi(castSession);
            }
            this.zzale();
        }
    }

    private void zzald() {
        if (!this.isActive()) {
            return;
        }
        for (zzoq zzoq2 : this.mE.values()) {
            zzoq2.zzalf();
        }
        this.jL.removeListener(this);
        this.jL = null;
    }

    private void zza(View view, zzoq zzoq2) {
        this.mE.put(view, zzoq2);
        if (this.isActive()) {
            zzoq2.zzi(this.jv.getCurrentCastSession());
            this.zzale();
        }
    }

    private void zzale() {
        for (zzoq zzoq2 : this.mE.values()) {
            zzoq2.zzalg();
        }
    }
}

