/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;

public class MiniControllerFragment
extends Fragment {
    private Drawable nd;
    private Drawable nb;
    private Drawable ns;
    private boolean nt;
    private int nu;
    private int nv;
    private UIMediaController nw;

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        this.nd = this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_pause);
        this.nb = this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_play);
        this.ns = this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_stop);
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.nt = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.nu = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.nv = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        typedArray.recycle();
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.nw = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.nw.bindViewVisibilityToMediaSession(view, 8);
        View view2 = view.findViewById(R.id.container_current);
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.nu != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.nu);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.nv != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.nv);
        }
        ImageView imageView2 = (ImageView)view.findViewById(R.id.play_pause);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_view);
        ProgressBar progressBar2 = (ProgressBar)view.findViewById(R.id.progressBar);
        this.nw.bindViewVisibilityToMediaSession(view2, 8);
        this.nw.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.nw.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.nw.bindImageViewToPlayPauseToggle(imageView2, this.nb, this.nd, this.ns, (View)progressBar, true);
        this.nw.bindProgressBar(progressBar2);
        this.nw.bindViewToLaunchExpandedController(view2);
        if (this.nt) {
            this.nw.bindImageViewToImageOfCurrentItem(imageView, -1, R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        return view;
    }

    public void onDestroy() {
        if (this.nw != null) {
            this.nw.dispose();
            this.nw = null;
        }
        super.onDestroy();
    }
}

