/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzoq;

public class zzoc
extends zzoq {
    private final ImageView mL;
    private final Context zzbxe;
    private final int mM;
    private final Bitmap mN;
    private final ImagePicker ln;
    private zznw mO;
    private Uri mP;

    public zzoc(ImageView imageView, Context context, int n, int n2) {
        this.mL = imageView;
        this.zzbxe = context.getApplicationContext();
        this.mM = n;
        this.mN = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.ln = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    @Override
    public void zzi(CastSession castSession) {
        super.zzi(castSession);
        this.mL.setImageBitmap(this.mN);
        this.zzalh();
    }

    @Override
    public void zzalf() {
        this.mP = null;
        if (this.mO != null) {
            this.mO.cancel(true);
            this.mO = null;
        }
        this.mL.setImageBitmap(this.mN);
        super.zzalf();
    }

    @Override
    public void zzalg() {
        this.zzalh();
    }

    private void zzalh() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.mP = null;
            this.mL.setImageBitmap(this.mN);
            return;
        }
        final Uri uri = this.zzc(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.mP = null;
            this.mL.setImageBitmap(this.mN);
        } else if (!zzf.zza((Object)this.mP, (Object)uri)) {
            this.mP = uri;
            this.mL.setImageBitmap(this.mN);
            this.mO = new zznw(this.zzbxe){

                protected void onPostExecute(Bitmap bitmap) {
                    if (bitmap != null && zzf.zza((Object)zzoc.this.mP, (Object)uri)) {
                        zzoc.this.mL.setImageBitmap(bitmap);
                    }
                }
            };
            this.mO.zzn(uri);
        }
    }

    private Uri zzc(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.ln != null && (webImage = this.ln.onPickImage(mediaInfo.getMetadata(), this.mM)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

