/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzaev;
import com.google.android.gms.internal.zzafa;

public final class zza
extends ViewGroup {
    private final int[] kv = new int[2];
    private final Rect kw = new Rect();
    private final Rect kx = new Rect();
    private final zze ky;
    private final zzc kz;
    private zzb kA;
    private View targetView;
    @Nullable
    private View kB;
    @Nullable
    private Animator kC;
    private final zzd kD;
    private final GestureDetectorCompat kE;
    @Nullable
    private GestureDetectorCompat kF;
    private zza kG;
    private boolean kH;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.kz = new zzc(context);
        this.kz.setCallback((Drawable.Callback)this);
        this.ky = new zze(context);
        this.ky.setCallback((Drawable.Callback)this);
        this.kD = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.ky.zzd(f2, f)) {
                    zza.this.kG.dismiss();
                }
                return true;
            }
        };
        this.kE = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.kE.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.kA = zzafa.zzaa(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzafa.zzaa(view);
        this.kB = view2;
        this.kG = zzafa.zzaa(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zzajk();
                }
                return true;
            }
        };
        this.kF = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.kF.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.kv, this.targetView);
        }
        this.kw.set(this.kv[0], this.kv[1], this.kv[0] + this.targetView.getWidth(), this.kv[1] + this.targetView.getHeight());
        if (this.kB != null) {
            this.zza(this.kv, this.kB);
            this.kx.set(this.kv[0], this.kv[1], this.kv[0] + this.kB.getMeasuredWidth(), this.kv[1] + this.kB.getMeasuredHeight());
        } else {
            this.kx.set(n, n2, n3, n4);
        }
        this.ky.setBounds(this.kx);
        this.kz.setBounds(this.kx);
        this.kD.zza(this.kw, this.kx);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.kB != null) {
            canvas.clipRect(this.kx);
        }
        this.ky.draw(canvas);
        this.kz.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.ky.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.kw.left, (float)this.kw.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 == this.ky) return true;
        if (drawable2 == this.kz) return true;
        if (drawable2 != null) return false;
        return true;
    }

    public void zzg(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zzajn();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zzajn() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zzajs());
    }

    public void zzh(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzj(runnable));
    }

    public void zzej(@ColorInt int n) {
        this.ky.setColor(n);
    }

    @Nullable
    Drawable zzajo() {
        return null;
    }

    View zzajp() {
        return this.kA.asView();
    }

    zze zzajq() {
        return this.ky;
    }

    zzc zzajr() {
        return this.kz;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.kC != null) {
            this.kC.cancel();
        }
        this.kC = animator;
        this.kC.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.kH = this.kw.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.kH) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.kF != null) {
                this.kF.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.kE.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.kx.contains(Math.round(f), Math.round(f2));
    }

    private Animator zzajs() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kA.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaev.zzcjr());
        float f = this.kw.exactCenterX() - this.ky.zzajw();
        float f2 = this.kw.exactCenterY() - this.ky.zzajx();
        Animator animator = this.ky.zze(f, f2);
        Animator animator2 = this.kz.zzajs();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.kC = zza.this.zzajt();
                zza.this.kC.start();
            }
        });
        return animatorSet;
    }

    private Animator zzj(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kA.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaev.zzcjs());
        Animator animator = this.ky.zzaju();
        Animator animator2 = this.kz.zzaju();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.kC = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kA.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaev.zzcjs());
        float f = this.kw.exactCenterX() - this.ky.zzajw();
        float f2 = this.kw.exactCenterY() - this.ky.zzajx();
        Animator animator = this.ky.zzf(f, f2);
        Animator animator2 = this.kz.zzajv();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.kC = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzajt() {
        return this.kz.zzajt();
    }

    public static interface zza {
        public void zzajk();

        public void dismiss();
    }
}

