/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final int mVersionCode;
    private final String jw;
    private final List<String> jx;
    private final boolean jy;
    private final LaunchOptions hA;
    private final boolean jz;
    private final CastMediaOptions jA;
    private final boolean jB;
    private final double jC;

    CastOptions(int n, String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.mVersionCode = n;
        this.jw = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n2 = list == null ? 0 : list.size();
        this.jx = new ArrayList<String>(n2);
        if (n2 > 0) {
            this.jx.addAll(list);
        }
        this.jy = bl;
        this.hA = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.jz = bl2;
        this.jA = castMediaOptions;
        this.jB = bl3;
        this.jC = d;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getReceiverApplicationId() {
        return this.jw;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.jx);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.jy;
    }

    public LaunchOptions getLaunchOptions() {
        return this.hA;
    }

    public boolean getResumeSavedSession() {
        return this.jz;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.jA;
    }

    public boolean getEnableReconnectionService() {
        return this.jB;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.jC;
    }

    public String toString() {
        return "CastOptions(" + String.format("receiverApplicationId=%s", this.jw) + ", " + String.format("supportedNamespaces=%s", this.jx) + ", " + String.format("stopReceiverApplicationWhenEndingSession=%b", this.jy) + ", " + String.format("launchOptions=%s", this.hA) + ", " + String.format("resumeSavedSession=%s", this.jz) + ", " + String.format("castMediaOptions=%s", new Object[]{this.jA}) + ", " + String.format("enableReconnectionService=%s", this.jB) + ")";
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastOptions)) {
            return false;
        }
        CastOptions castOptions = (CastOptions)((Object)object);
        return zzf.zza((Object)this.jw, (Object)castOptions.jw) && zzf.zza(this.jx, castOptions.jx) && this.jy == castOptions.jy && zzf.zza((Object)this.hA, (Object)castOptions.hA) && this.jz == castOptions.jz && zzf.zza((Object)((Object)this.jA), (Object)((Object)castOptions.jA)) && this.jB == castOptions.getEnableReconnectionService() && this.jC == castOptions.getVolumeDeltaBeforeIceCreamSandwich();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.jw, this.jx, this.jy, this.hA, this.jz, this.jA, this.jB, this.jC});
    }

    public static final class Builder {
        private String jw;
        private List<String> jx = new ArrayList<String>();
        private boolean jy;
        private LaunchOptions hA = new LaunchOptions();
        private boolean jz = true;
        private CastMediaOptions jA = new CastMediaOptions.Builder().build();
        private boolean jB = true;
        private double jC = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.jw = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.jx = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.jy = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.hA = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.jz = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.jA = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.jB = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.jC = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(1, this.jw, this.jx, this.jy, this.hA, this.jz, this.jA, this.jB, this.jC);
        }
    }
}

