/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zznv;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzm jo = new zzm("CastSession");
    private final Context zzbxa;
    private final Set<Cast.Listener> jD = new HashSet<Cast.Listener>();
    private final zzh jE;
    private final Cast.CastApi jF;
    private final zznk jG;
    private final zznv jH;
    private GoogleApiClient gY;
    private RemoteMediaClient jI;
    private CastDevice jJ;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zznk zznk2, zznv zznv2) {
        super(context, string2, string3);
        this.zzbxa = context.getApplicationContext();
        this.jF = castApi;
        this.jG = zznk2;
        this.jH = zznv2;
        this.jE = zzni.zza(context, castOptions, this.zzaiw(), new zzb());
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzj(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.jE.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzh.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.jI;
    }

    public CastDevice getCastDevice() {
        return this.jJ;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        if (this.gY != null) {
            this.jF.requestStatus(this.gY);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        return this.gY != null ? this.jF.getActiveInputState(this.gY) : -1;
    }

    public int getStandbyState() throws IllegalStateException {
        return this.gY != null ? this.jF.getStandbyState(this.gY) : -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        return this.gY != null ? this.jF.getApplicationMetadata(this.gY) : null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        return this.gY != null ? this.jF.getApplicationStatus(this.gY) : null;
    }

    public void setVolume(double d) throws IOException {
        if (this.gY != null) {
            this.jF.setVolume(this.gY, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        return this.gY != null ? this.jF.getVolume(this.gY) : 0.0;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        if (this.gY != null) {
            this.jF.setMute(this.gY, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        return this.gY != null ? this.jF.isMute(this.gY) : false;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        if (this.gY != null) {
            this.jF.setMessageReceivedCallbacks(this.gY, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        if (this.gY != null) {
            this.jF.removeMessageReceivedCallbacks(this.gY, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        return this.gY != null ? this.jF.sendMessage(this.gY, string2, string3) : null;
    }

    public void addCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.jD.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        if (listener != null) {
            this.jD.remove(listener);
        }
    }

    private void zzj(Bundle bundle) {
        this.jJ = CastDevice.getFromBundle((Bundle)bundle);
        if (this.jJ == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
            } else {
                this.notifyFailedToStartSession(8);
            }
            return;
        }
        if (this.gY != null) {
            this.gY.disconnect();
            this.gY = null;
        }
        jo.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.jJ});
        zzd zzd2 = new zzd();
        this.gY = this.jG.zza(this.zzbxa, this.jJ, new zzc(), zzd2, zzd2);
        this.gY.connect();
    }

    private void zzei(int n) {
        this.jH.zzen(n);
        if (this.gY != null) {
            this.gY.disconnect();
            this.gY = null;
        }
        this.jJ = null;
        if (this.jI != null) {
            try {
                this.jI.zzd(null);
            }
            catch (IOException iOException) {
                jo.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
            }
            this.jI = null;
        }
    }

    @Override
    public long getSessionRemainingTimeMs() {
        if (this.jI == null) {
            return 0L;
        }
        return this.jI.getStreamDuration() - this.jI.getApproximateStreamPosition();
    }

    private class zzb
    extends zzf.zza {
        private zzb() {
        }

        @Override
        public int zzaij() {
            return 9452208;
        }

        @Override
        public void zzz(String string, String string2) {
            CastSession.this.jF.joinApplication(CastSession.this.gY, string, string2).setResultCallback((ResultCallback)new zza("joinApplication"));
        }

        @Override
        public void zza(String string, LaunchOptions launchOptions) {
            CastSession.this.jF.launchApplication(CastSession.this.gY, string, launchOptions).setResultCallback((ResultCallback)new zza("launchApplication"));
        }

        @Override
        public void zzgd(String string) {
            CastSession.this.jF.stopApplication(CastSession.this.gY, string);
        }

        @Override
        public void zzei(int n) {
            CastSession.this.zzei(n);
        }
    }

    private class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        String jK;

        zza(String string) {
            this.jK = string;
        }

        public void zza(@NonNull Cast.ApplicationConnectionResult applicationConnectionResult) {
            block5: {
                try {
                    if (applicationConnectionResult.getStatus().isSuccess()) {
                        jo.zzb("%s() -> success result", new Object[]{this.jK});
                        CastSession.this.jI = new RemoteMediaClient(new zzn(null), CastSession.this.jF);
                        try {
                            CastSession.this.jI.zzd(CastSession.this.gY);
                            CastSession.this.jI.requestStatus();
                            CastSession.this.jH.zza(CastSession.this.jI, CastSession.this.getCastDevice());
                        }
                        catch (IOException iOException) {
                            jo.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                            CastSession.this.jI = null;
                        }
                        CastSession.this.jE.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                        break block5;
                    }
                    jo.zzb("%s() -> failure result", new Object[]{this.jK});
                    CastSession.this.jE.zzej(applicationConnectionResult.getStatus().getStatusCode());
                }
                catch (RemoteException remoteException) {
                    jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzh.class.getSimpleName()});
                }
            }
        }

        public /* synthetic */ void onResult(@NonNull Result result) {
            this.zza((Cast.ApplicationConnectionResult)result);
        }
    }

    private class zzc
    extends Cast.Listener {
        private zzc() {
        }

        public void onApplicationDisconnected(int n) {
            CastSession.this.zzei(n);
            CastSession.this.notifySessionEnded(n);
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationDisconnected(n);
            }
        }

        public void onApplicationStatusChanged() {
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationStatusChanged();
            }
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public void onActiveInputStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onActiveInputStateChanged(n);
            }
        }

        public void onStandbyStateChanged(int n) {
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onStandbyStateChanged(n);
            }
        }

        public void onVolumeChanged() {
            HashSet hashSet = new HashSet(CastSession.this.jD);
            for (Cast.Listener listener : hashSet) {
                listener.onVolumeChanged();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        public void onConnected(Bundle bundle) {
            try {
                CastSession.this.jE.onConnected(bundle);
            }
            catch (RemoteException remoteException) {
                jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionSuspended(int n) {
            try {
                CastSession.this.jE.onConnectionSuspended(n);
            }
            catch (RemoteException remoteException) {
                jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzh.class.getSimpleName()});
            }
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                CastSession.this.jE.onConnectionFailed(connectionResult);
            }
            catch (RemoteException remoteException) {
                jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzh.class.getSimpleName()});
            }
        }
    }
}

