/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzaes;
import com.google.android.gms.internal.zzaex;

public final class zza
extends ViewGroup {
    private final int[] ks = new int[2];
    private final Rect kt = new Rect();
    private final Rect ku = new Rect();
    private final zze kv;
    private final zzc kw;
    private zzb kx;
    private View targetView;
    @Nullable
    private View ky;
    @Nullable
    private Animator kz;
    private final zzd kA;
    private final GestureDetectorCompat kB;
    @Nullable
    private GestureDetectorCompat kC;
    private zza kD;
    private boolean kE;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.kw = new zzc(context);
        this.kw.setCallback((Drawable.Callback)this);
        this.kv = new zze(context);
        this.kv.setCallback((Drawable.Callback)this);
        this.kA = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.kv.zzd(f2, f)) {
                    zza.this.kD.dismiss();
                }
                return true;
            }
        };
        this.kB = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.kB.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.kx = zzaex.zzy(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzaex.zzy(view);
        this.ky = view2;
        this.kD = zzaex.zzy(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zzajm();
                }
                return true;
            }
        };
        this.kC = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.kC.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.ks, this.targetView);
        }
        this.kt.set(this.ks[0], this.ks[1], this.ks[0] + this.targetView.getWidth(), this.ks[1] + this.targetView.getHeight());
        if (this.ky != null) {
            this.zza(this.ks, this.ky);
            this.ku.set(this.ks[0], this.ks[1], this.ks[0] + this.ky.getMeasuredWidth(), this.ks[1] + this.ky.getMeasuredHeight());
        } else {
            this.ku.set(n, n2, n3, n4);
        }
        this.kv.setBounds(this.ku);
        this.kw.setBounds(this.ku);
        this.kA.zza(this.kt, this.ku);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.ky != null) {
            canvas.clipRect(this.ku);
        }
        this.kv.draw(canvas);
        this.kw.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.kv.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.kt.left, (float)this.kt.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 == this.kv) return true;
        if (drawable2 == this.kw) return true;
        if (drawable2 != null) return false;
        return true;
    }

    public void zzh(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zzajp();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zzajp() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zzaju());
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzl(runnable));
    }

    public void zzj(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzek(@ColorInt int n) {
        this.kv.setColor(n);
    }

    @Nullable
    Drawable zzajq() {
        return null;
    }

    View zzajr() {
        return this.kx.asView();
    }

    zze zzajs() {
        return this.kv;
    }

    zzc zzajt() {
        return this.kw;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.kz != null) {
            this.kz.cancel();
        }
        this.kz = animator;
        this.kz.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.kE = this.kt.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.kE) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.kC != null) {
                this.kC.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.kB.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.ku.contains(Math.round(f), Math.round(f2));
    }

    private Animator zzaju() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kx.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaes.zzcjr());
        float f = this.kt.exactCenterX() - this.kv.getCenterX();
        float f2 = this.kt.exactCenterY() - this.kv.getCenterY();
        Animator animator = this.kv.zze(f, f2);
        Animator animator2 = this.kw.zzaju();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.kz = zza.this.zzajv();
                zza.this.kz.start();
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kx.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaes.zzcjs());
        Animator animator = this.kv.zzajw();
        Animator animator2 = this.kw.zzajw();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.kz = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzl(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.kx.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzaes.zzcjs());
        float f = this.kt.exactCenterX() - this.kv.getCenterX();
        float f2 = this.kt.exactCenterY() - this.kv.getCenterY();
        Animator animator = this.kv.zzf(f, f2);
        Animator animator2 = this.kw.zzajx();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.kz = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzajv() {
        return this.kw.zzajv();
    }

    public static interface zza {
        public void zzajm();

        public void dismiss();
    }
}

