/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzno;

public class zznp
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean kf;
    private Activity mActivity;
    private int kk;
    private boolean kh;
    private IntroductoryOverlay.OnOverlayDismissedListener jR;
    private final zza kl;

    public zznp(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    @TargetApi(value=14)
    public zznp(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), attributeSet, n);
        Rect rect;
        this.mActivity = builder.getActivity();
        this.kf = builder.zzajd();
        this.jR = builder.zzajb();
        TypedArray typedArray = this.mActivity.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzaja() != null) {
            rect = new Rect();
            builder.zzaja().getGlobalVisibleRect(rect);
            this.kl = new zza();
            this.kl.x = rect.centerX();
            this.kl.y = rect.centerY();
            this.kl.ko = this.zzajn();
            this.kl.kp = builder.zzajg();
            if (this.kl.kp == 0.0f) {
                this.kl.kp = typedArray.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.kl = null;
        }
        rect = LayoutInflater.from((Context)this.mActivity);
        rect.inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.kk = builder.zzajc();
        if (this.kk == 0) {
            this.kk = typedArray.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzaje())) {
            textView.setText((CharSequence)builder.zzaje());
            int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        this.zza(builder.zzajf(), typedArray);
        typedArray.recycle();
        if (Build.VERSION.SDK_INT >= 14) {
            this.setFitsSystemWindows(true);
        }
    }

    @Override
    public void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzno.zzbi((Context)this.mActivity)) {
            return;
        }
        if (this.kf && IntroductoryOverlay.zza.zzbf((Context)this.mActivity)) {
            this.mActivity = null;
            this.jR = null;
            return;
        }
        if (!this.kh) {
            this.kh = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.jR = null;
    }

    @TargetApi(value=11)
    private void zza(String string2, TypedArray typedArray) {
        String string3 = string2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string3 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)this.findViewById(R.id.button);
        button.setText((CharSequence)string3);
        button.getBackground().setColorFilter(n, PorterDuff.Mode.MULTIPLY);
        int n2 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n2 != 0) {
            button.setTextAppearance((Context)this.mActivity, n2);
        }
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Build.VERSION.SDK_INT >= 16) {
                    ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{0.0f});
                    objectAnimator.setDuration(400L).addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animator) {
                            zznp.this.zzajo();
                        }
                    });
                    objectAnimator.start();
                } else {
                    zznp.this.zzajo();
                }
            }
        });
    }

    private Paint zzajn() {
        PorterDuffXfermode porterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setAlpha(0);
        paint.setXfermode((Xfermode)porterDuffXfermode);
        paint.setAntiAlias(true);
        return paint;
    }

    protected void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.kk);
        if (this.kl != null) {
            canvas2.drawCircle((float)this.kl.x, (float)this.kl.y, this.kl.kp, this.kl.ko);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private void zzajo() {
        IntroductoryOverlay.zza.zzbe((Context)this.mActivity);
        if (this.jR != null) {
            this.jR.onOverlayDismissed();
            this.jR = null;
        }
        this.remove();
    }

    private static class zza {
        public int x;
        public int y;
        public Paint ko;
        public float kp;

        private zza() {
        }
    }
}

