/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zznr;
import com.google.android.gms.internal.zzns;

public class zznv
implements RemoteMediaClient.Listener {
    private final Context zzbxa;
    private final CastOptions ms;
    private final zznr ke;
    private final ComponentName mt;
    private RemoteMediaClient jI;
    private CastDevice gB;
    private MediaSessionCompat mu;
    private MediaSessionCompat.Callback mv;
    private zzns mw;
    private boolean mx;

    public zznv(Context context, CastOptions castOptions, zznr zznr2) {
        this.zzbxa = context;
        this.ms = castOptions;
        this.ke = zznr2;
        this.mt = this.ms.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.ms.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzbxa, this.ms.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mx || this.ms == null || this.ms.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.jI = remoteMediaClient;
        this.jI.addListener(this);
        this.gB = castDevice;
        AudioManager audioManager = (AudioManager)this.zzbxa.getSystemService("audio");
        audioManager.requestAudioFocus(null, 3, 3);
        ComponentName componentName = new ComponentName(this.zzbxa, this.ms.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzbxa, (int)0, (Intent)intent, (int)0);
        this.mu = new MediaSessionCompat(this.zzbxa, "CastMediaSession", componentName, pendingIntent);
        this.mu.setFlags(3);
        this.zza(0, null);
        if (this.gB != null && !TextUtils.isEmpty((CharSequence)this.gB.getFriendlyName())) {
            this.mu.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzbxa.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.gB.getFriendlyName()})).build());
        }
        this.mv = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zznv.this.jI.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zznv.this.jI.togglePlayback();
            }

            public void onPause() {
                zznv.this.jI.togglePlayback();
            }
        };
        this.mu.setCallback(this.mv);
        this.mu.setActive(true);
        this.ke.setMediaSessionCompat(this.mu);
        this.mx = true;
        this.zzakx();
    }

    public void zzen(int n) {
        if (!this.mx) {
            return;
        }
        this.mx = false;
        if (this.jI != null) {
            this.jI.removeListener(this);
        }
        AudioManager audioManager = (AudioManager)this.zzbxa.getSystemService("audio");
        audioManager.abandonAudioFocus(null);
        this.ke.setMediaSessionCompat(null);
        if (this.mw != null) {
            this.mw.cancel(true);
            this.mw = null;
        }
        if (this.mu != null) {
            this.mu.setSessionActivity(null);
            this.mu.setCallback(null);
            this.mu.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.mu.setActive(false);
            this.mu.release();
            this.mu = null;
        }
        this.jI = null;
        this.gB = null;
        this.mv = null;
        this.zzala();
        if (n == 0) {
            this.zzalc();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.mu == null ? null : this.mu.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzakx();
    }

    @Override
    public void onStatusUpdated() {
        this.zzakx();
    }

    @Override
    public void onMetadataUpdated() {
        this.zzakx();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzakx();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zzakx() {
        MediaStatus mediaStatus = this.jI.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        int n = 0;
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.jI.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.jI.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    if (bl) {
                        mediaInfo = mediaStatus.getQueueItemById(n3).getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzala();
            this.zzalc();
        } else {
            this.zzakz();
            if (!bl) {
                this.zzalb();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.mu.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.mu.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.mu.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.mu.setSessionActivity(this.zzald());
            this.zza(mediaInfo);
        }
    }

    private void zza(MediaInfo mediaInfo) {
        if (this.mw != null) {
            this.mw.cancel(true);
            this.mw = null;
        }
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zzaky().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        Uri uri = this.zzb(mediaMetadata);
        if (uri == null) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.zzbxa.getResources(), (int)(Build.VERSION.SDK_INT > 18 ? R.drawable.cast_album_art_placeholder_large : R.drawable.cast_album_art_placeholder));
            this.mu.setMetadata(zznv.zza(builder, bitmap).build());
        } else {
            this.mu.setMetadata(builder.build());
            this.mw = new zzns(this.zzbxa){

                protected void onPostExecute(Bitmap bitmap) {
                    if (zznv.this.mw == this) {
                        zznv.this.mw = null;
                        if (bitmap != null) {
                            zznv.this.mu.setMetadata(zznv.zza(zznv.this.zzaky(), bitmap).build());
                        }
                    }
                }
            };
            this.mw.zzn(uri);
        }
    }

    private static MediaMetadataCompat.Builder zza(MediaMetadataCompat.Builder builder, Bitmap bitmap) {
        builder.putBitmap("android.media.metadata.ALBUM_ART", bitmap);
        if (Build.VERSION.SDK_INT < 21) {
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            builder.putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2);
        }
        return builder;
    }

    private Uri zzb(MediaMetadata mediaMetadata) {
        WebImage webImage = this.ms.getCastMediaOptions().getImagePicker() != null ? this.ms.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, 0) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zzaky() {
        MediaMetadataCompat mediaMetadataCompat = this.mu.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zzakz() {
        if (this.ms.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.jI == null) {
            return;
        }
        Intent intent = new Intent(this.zzbxa, MediaNotificationService.class);
        intent.setPackage(this.zzbxa.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.jI.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.jI.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.gB);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.jI.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzbxa.startService(intent);
    }

    private void zzala() {
        if (this.ms.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzbxa, MediaNotificationService.class);
        intent.setPackage(this.zzbxa.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzbxa.stopService(intent);
    }

    private void zzalb() {
        if (!this.ms.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbxa, ReconnectionService.class);
        intent.setPackage(this.zzbxa.getPackageName());
        this.zzbxa.startService(intent);
    }

    private void zzalc() {
        if (!this.ms.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbxa, ReconnectionService.class);
        intent.setPackage(this.zzbxa.getPackageName());
        this.zzbxa.stopService(intent);
    }

    private PendingIntent zzald() {
        if (this.mt == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.mt);
        return PendingIntent.getActivity((Context)this.zzbxa, (int)0, (Intent)intent, (int)0x8000000);
    }
}

