/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzns;

public class zzny
extends UIController {
    private final ImageView mI;
    private final Context zzbxa;
    private final int mJ;
    private final Bitmap mP;
    private final View mQ;
    private final ImagePicker li;
    private zzns mL;
    private Uri mM;
    private Bitmap mBitmap;

    public zzny(ImageView imageView, Context context, int n, int n2) {
        this.mI = imageView;
        this.zzbxa = context.getApplicationContext();
        this.mJ = n;
        this.mP = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        this.mQ = null;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.li = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    public zzny(ImageView imageView, Context context, int n, View view) {
        this.mI = imageView;
        this.zzbxa = context.getApplicationContext();
        this.mJ = n;
        this.mQ = view;
        this.mP = null;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.li = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzalh();
        this.zzalg();
    }

    @Override
    public void onSessionEnded() {
        this.mM = null;
        if (this.mL != null) {
            this.mL.cancel(true);
            this.mL = null;
        }
        this.zzalh();
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzalg();
    }

    private void zzalg() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.mM = null;
            this.zzalh();
            return;
        }
        final Uri uri = this.zzc(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.mM = null;
            this.zzalh();
        } else if (!zzf.zza((Object)this.mM, (Object)uri)) {
            this.mM = uri;
            this.zzalh();
            this.mL = new zzns(this.zzbxa){

                protected void onPostExecute(Bitmap bitmap) {
                    if (bitmap != null && zzf.zza((Object)zzny.this.mM, (Object)uri)) {
                        if (zzny.this.mQ != null) {
                            zzny.this.mQ.setVisibility(4);
                        }
                        zzny.this.mI.setVisibility(0);
                        zzny.this.mI.setImageBitmap(bitmap);
                        if (zzny.this.mBitmap != null) {
                            zzny.this.mBitmap.recycle();
                        }
                        zzny.this.mBitmap = bitmap;
                    }
                }
            };
            this.mL.zzn(uri);
        }
    }

    private Uri zzc(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.li != null && (webImage = this.li.onPickImage(mediaInfo.getMetadata(), this.mJ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }

    private void zzalh() {
        if (this.mQ != null) {
            this.mQ.setVisibility(0);
            this.mI.setVisibility(4);
        }
        if (this.mP != null) {
            this.mI.setImageBitmap(this.mP);
        }
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

