/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaIntentReceiver;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.zza;
import com.google.android.gms.cast.framework.media.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import java.util.Locale;

public class CastMediaOptions
extends AbstractSafeParcelable {
    private static final zzm mL = new zzm("CastMediaOptions");
    public static final Parcelable.Creator<CastMediaOptions> CREATOR = new zza();
    private final int mVersionCode;
    private final String oC;
    private final String oD;
    private final zzb oE;
    private final NotificationOptions oF;

    CastMediaOptions(int n, String string2, String string3, IBinder iBinder, NotificationOptions notificationOptions) {
        this.mVersionCode = n;
        this.oC = string2;
        this.oD = string3;
        this.oE = zzb.zza.zzdc(iBinder);
        this.oF = notificationOptions;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getMediaIntentReceiverClassName() {
        return this.oC;
    }

    public NotificationOptions getNotificationOptions() {
        return this.oF;
    }

    public String getExpandedControllerActivityClassName() {
        return this.oD;
    }

    public ImagePicker getImagePicker() {
        if (this.oE != null) {
            try {
                return (ImagePicker)zze.zzae((zzd)this.oE.zzals());
            }
            catch (RemoteException remoteException) {
                mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedClientObject", zzb.class.getSimpleName()});
            }
        }
        return null;
    }

    public IBinder zzalr() {
        return this.oE == null ? null : this.oE.asBinder();
    }

    public String toString() {
        return String.format(Locale.ROOT, "CastMediaOptions(mediaIntentReceiverClassName=%s, expandedControllerActivityClassName=%s, notificationOptions=%s)", new Object[]{this.oC, this.oD, this.oF});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastMediaOptions)) {
            return false;
        }
        CastMediaOptions castMediaOptions = (CastMediaOptions)((Object)object);
        return zzf.zza((Object)this.oC, (Object)castMediaOptions.getMediaIntentReceiverClassName()) && zzf.zza((Object)this.oD, (Object)castMediaOptions.oD) && zzf.zza((Object)((Object)this.oF), (Object)((Object)castMediaOptions.oF));
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.oC, this.oD, this.oF});
    }

    public static final class Builder {
        private String oC = MediaIntentReceiver.class.getName();
        private String oD;
        private ImagePicker oG;
        private NotificationOptions oF = new NotificationOptions.Builder().build();

        public Builder setMediaIntentReceiverClassName(String string2) {
            this.oC = string2;
            return this;
        }

        public Builder setExpandedControllerActivityClassName(String string2) {
            this.oD = string2;
            return this;
        }

        public Builder setImagePicker(ImagePicker imagePicker) {
            this.oG = imagePicker;
            return this;
        }

        public Builder setNotificationOptions(NotificationOptions notificationOptions) {
            this.oF = notificationOptions;
            return this;
        }

        public CastMediaOptions build() {
            IBinder iBinder = this.oG == null ? null : this.oG.zzalt().asBinder();
            return new CastMediaOptions(1, this.oC, this.oD, iBinder, this.oF);
        }
    }
}

