/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzagd;
import com.google.android.gms.internal.zzagi;

public final class zza
extends ViewGroup {
    private final int[] nQ = new int[2];
    private final Rect nR = new Rect();
    private final Rect nS = new Rect();
    private final zze nT;
    private final zzc nU;
    private zzb nV;
    private View targetView;
    @Nullable
    private View nW;
    @Nullable
    private Animator nX;
    private final zzd nY;
    private final GestureDetectorCompat nZ;
    @Nullable
    private GestureDetectorCompat oa;
    private zza ob;
    private boolean oc;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.nU = new zzc(context);
        this.nU.setCallback((Drawable.Callback)this);
        this.nT = new zze(context);
        this.nT.setCallback((Drawable.Callback)this);
        this.nY = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.nT.zzd(f2, f)) {
                    zza.this.ob.dismiss();
                }
                return true;
            }
        };
        this.nZ = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.nZ.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.nV = zzagi.zzy(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzagi.zzy(view);
        this.nW = view2;
        this.ob = zzagi.zzy(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zzalf();
                }
                return true;
            }
        };
        this.oa = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.oa.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.nQ, this.targetView);
        }
        this.nR.set(this.nQ[0], this.nQ[1], this.nQ[0] + this.targetView.getWidth(), this.nQ[1] + this.targetView.getHeight());
        if (this.nW != null) {
            this.zza(this.nQ, this.nW);
            this.nS.set(this.nQ[0], this.nQ[1], this.nQ[0] + this.nW.getMeasuredWidth(), this.nQ[1] + this.nW.getMeasuredHeight());
        } else {
            this.nS.set(n, n2, n3, n4);
        }
        this.nT.setBounds(this.nS);
        this.nU.setBounds(this.nS);
        this.nY.zza(this.nR, this.nS);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.nW != null) {
            canvas.clipRect(this.nS);
        }
        this.nT.draw(canvas);
        this.nU.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.nT.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.nR.left, (float)this.nR.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 == this.nT) return true;
        if (drawable2 == this.nU) return true;
        if (drawable2 != null) return false;
        return true;
    }

    public void zzh(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zzali();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zzali() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zzaln());
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzl(runnable));
    }

    public void zzj(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzer(@ColorInt int n) {
        this.nT.setColor(n);
    }

    @Nullable
    Drawable zzalj() {
        return null;
    }

    View zzalk() {
        return this.nV.asView();
    }

    zze zzall() {
        return this.nT;
    }

    zzc zzalm() {
        return this.nU;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.nX != null) {
            this.nX.cancel();
        }
        this.nX = animator;
        this.nX.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.oc = this.nR.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.oc) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.oa != null) {
                this.oa.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.nZ.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.nS.contains(Math.round(f), Math.round(f2));
    }

    private Animator zzaln() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.nV.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagd.zzcnl());
        float f = this.nR.exactCenterX() - this.nT.getCenterX();
        float f2 = this.nR.exactCenterY() - this.nT.getCenterY();
        Animator animator = this.nT.zze(f, f2);
        Animator animator2 = this.nU.zzaln();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.nX = zza.this.zzalo();
                zza.this.nX.start();
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.nV.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagd.zzcnm());
        Animator animator = this.nT.zzalp();
        Animator animator2 = this.nU.zzalp();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.nX = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzl(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.nV.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzagd.zzcnm());
        float f = this.nR.exactCenterX() - this.nT.getCenterX();
        float f2 = this.nR.exactCenterY() - this.nT.getCenterY();
        Animator animator = this.nT.zzf(f, f2);
        Animator animator2 = this.nU.zzalq();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.nX = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzalo() {
        return this.nU.zzalo();
    }

    public static interface zza {
        public void zzalf();

        public void dismiss();
    }
}

