/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzor;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzou;
import com.google.android.gms.internal.zzov;
import com.google.android.gms.internal.zzow;
import com.google.android.gms.internal.zzox;
import com.google.android.gms.internal.zzoy;
import com.google.android.gms.internal.zzoz;
import com.google.android.gms.internal.zzpa;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager mP;
    private final Map<View, UIController> qb = new HashMap<View, UIController>();
    private final Set<zzpb> qc = new HashSet<zzpb>();
    private RemoteMediaClient.Listener qd;
    private RemoteMediaClient nf;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.mP = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.mP.addSessionManagerListener(this, CastSession.class);
        this.zza(this.mP.getCurrentCastSession());
    }

    public boolean isActive() {
        return this.nf != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.nf;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        this.qd = listener;
    }

    public void dispose() {
        this.zzamy();
        this.qb.clear();
        this.mP.removeSessionManagerListener(this, CastSession.class);
        this.qd = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zza((View)imageView, new zzou(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        this.zza(view, new zzoy(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        this.zza(view, new zzoz(view, n));
    }

    public void bindViewToForward(View view, long l) {
        this.zza(view, new zzox(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        this.zza(view, new zzoq(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        this.zza((View)progressBar, new zzov(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                for (zzpb zzpb2 : UIMediaController.this.qc) {
                    zzpb2.zzbn(true);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                for (zzpb zzpb2 : UIMediaController.this.qc) {
                    zzpb2.zzbn(false);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzpb zzpb2 : UIMediaController.this.qc) {
                        zzpb2.zzad(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzow(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzpb zzpb2 = new zzpb(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.qc.add(zzpb2);
        }
        this.zza((View)textView, zzpb2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        this.zza((View)textView, new zzpa(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        this.zza((View)textView, new zzpa(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        this.zza(view, new zzoo(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        this.zza(view, new zzol(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        this.zza((View)imageView, new zzot(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzos(textView, list));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzon(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        this.zza((View)imageView, new zzon(imageView, (Context)this.mActivity, n, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        this.zza(view, new zzpd(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzor(textView, list));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzom(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        this.zza(view, new zzpc(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        this.zza(view, uIController);
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzamy();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzamy();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzamy();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzamz();
        if (this.qd != null) {
            this.qd.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzamz();
        if (this.qd != null) {
            this.qd.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzamz();
        if (this.qd != null) {
            this.qd.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzamz();
        if (this.qd != null) {
            this.qd.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (UIController uIController : this.qb.values()) {
            uIController.onSendingRemoteMediaRequest();
        }
        if (this.qd != null) {
            this.qd.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.nf = castSession.getRemoteMediaClient();
        if (this.nf != null) {
            this.nf.addListener(this);
            for (UIController uIController : this.qb.values()) {
                uIController.onSessionConnected(castSession);
            }
            this.zzamz();
        }
    }

    private void zzamy() {
        if (!this.isActive()) {
            return;
        }
        for (UIController uIController : this.qb.values()) {
            uIController.onSessionEnded();
        }
        this.nf.removeListener(this);
        this.nf = null;
    }

    private void zza(View view, UIController uIController) {
        this.qb.put(view, uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.mP.getCurrentCastSession());
            this.zzamz();
        }
    }

    private void zzamz() {
        for (UIController uIController : this.qb.values()) {
            uIController.onMediaStatusUpdated();
        }
    }
}

