/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzog;

public class zzom
extends UIController {
    private final ImageView qk;
    private final Context zzcbt;
    private final int ql;
    private final Bitmap qm;
    private final ImagePicker oG;
    private zzog qn;
    private Uri qo;

    public zzom(ImageView imageView, Context context, int n, int n2) {
        this.qk = imageView;
        this.zzcbt = context.getApplicationContext();
        this.ql = n;
        this.qm = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.oG = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.qk.setImageBitmap(this.qm);
        this.zzana();
    }

    @Override
    public void onSessionEnded() {
        this.qo = null;
        if (this.qn != null) {
            this.qn.cancel(true);
            this.qn = null;
        }
        this.qk.setImageBitmap(this.qm);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzana();
    }

    private void zzana() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.qk.setImageBitmap(this.qm);
            return;
        }
        final Uri uri = this.zza(remoteMediaClient.getPreloadedItem());
        if (uri == null) {
            this.qo = null;
            this.qk.setImageBitmap(this.qm);
        } else if (!zzf.zza((Object)this.qo, (Object)uri)) {
            this.qo = uri;
            this.qk.setImageBitmap(this.qm);
            this.qn = new zzog(this.zzcbt){

                protected void onPostExecute(Bitmap bitmap) {
                    if (bitmap != null && zzf.zza((Object)zzom.this.qo, (Object)uri)) {
                        zzom.this.qk.setImageBitmap(bitmap);
                    }
                }
            };
            this.qn.zzo(uri);
        }
    }

    private Uri zza(MediaQueueItem mediaQueueItem) {
        WebImage webImage;
        if (mediaQueueItem == null) {
            return null;
        }
        MediaInfo mediaInfo = mediaQueueItem.getMedia();
        if (mediaInfo == null) {
            return null;
        }
        if (this.oG != null && (webImage = this.oG.onPickImage(mediaInfo.getMetadata(), this.ql)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

