/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzop;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzm oT = new zzm("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static zza oU;
    private static CastContext oV;
    private final Context zzcfo;
    private final zzg oW;
    private final SessionManager oX;
    private final zzd oY;
    private final CastOptions oZ;
    private zzop pa;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzaa.zzhs((String)"getSharedInstance must be called from the main thread.");
        if (oV == null) {
            OptionsProvider optionsProvider = CastContext.zzbb(context.getApplicationContext());
            oV = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
            if (zzs.zzayq()) {
                oU = new zza(context.getApplicationContext());
                Application application = (Application)context.getApplicationContext();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)oU);
            }
        }
        return oV;
    }

    private static OptionsProvider zzbb(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzcfo = context.getApplicationContext();
        this.oZ = castOptions;
        this.pa = new zzop(MediaRouter.getInstance((Context)this.zzcfo));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzoh zzoh2 = new zzoh(this.zzcfo, castOptions, this.pa);
        hashMap.put(zzoh2.getCategory(), zzoh2.zzamk());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzaa.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzaa.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzaa.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzamk());
            }
        }
        this.oW = zzog.zza(this.zzcfo, castOptions, this.pa, hashMap);
        Object object3 = null;
        try {
            object3 = this.oW.zzalu();
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.oY = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.oW.zzalt();
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.oX = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzaa.zzhs((String)"getCastOptions must be called from the main thread.");
        return this.oZ;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzaa.zzhs((String)"getSessionManager must be called from the main thread.");
        return this.oX;
    }

    public MediaRouteSelector zzalo() throws IllegalStateException {
        zzaa.zzhs((String)"getMergedSelector must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.oW.zzals());
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzaa.zzhs((String)"isAppVisible must be called from the main thread.");
        try {
            return this.oW.isAppVisible();
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzaa.zzhs((String)"addAppVisibilityListener must be called from the main thread.");
        zzaa.zzy((Object)appVisibilityListener);
        try {
            this.oW.zza(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzaa.zzhs((String)"removeAppVisibilityListener must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.oW.zzb(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzaa.zzhs((String)"addCastStateListener must be called from the main thread.");
        zzaa.zzy((Object)castStateListener);
        this.oX.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzaa.zzhs((String)"addCastStateListener must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.oX.removeCastStateListener(castStateListener);
    }

    public zzd zzalp() {
        zzaa.zzhs((String)"getDiscoveryManager must be called from the main thread.");
        return this.oY;
    }

    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
        if (!zzs.zzayq()) {
            zzof.zza(fragmentActivity, bundle);
        }
    }

    public void onActivityResumed(Activity activity) {
        zzaa.zzhs((String)"onActivityResumed must be called from the main thread.");
        try {
            this.oW.zzx(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityResumed", zzg.class.getSimpleName()});
        }
    }

    public void onActivityPaused(Activity activity) {
        zzaa.zzhs((String)"onActivityPaused must be called from the main thread.");
        try {
            this.oW.zzy(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityPaused", zzg.class.getSimpleName()});
        }
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzaa.zzhs((String)"onDispatchVolumeKeyEventBeforeJellyBean must be called from the main thread.");
        if (zzs.zzayr()) {
            return false;
        }
        CastSession castSession = this.oX.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                if (!this.zza(castSession, d, bl)) break;
                return true;
            }
            case 25: {
                if (!this.zza(castSession, -d, bl)) break;
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                oT.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public com.google.android.gms.dynamic.zzd zzalq() {
        try {
            return this.oW.zzalv();
        }
        catch (RemoteException remoteException) {
            oT.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private Context zzcfo;

        public zza(Context context) {
            this.zzcfo = context.getApplicationContext();
        }

        public void onActivityResumed(Activity activity) {
            CastContext.getSharedInstance(this.zzcfo).onActivityResumed(activity);
        }

        public void onActivityPaused(Activity activity) {
            CastContext.getSharedInstance(this.zzcfo).onActivityPaused(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

