/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View pu;
        private int pv;
        private String pw;
        private OnOverlayDismissedListener px;
        private boolean py;
        private float pz;
        private String pA;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzaa.zzy((Object)activity);
            if (zzs.zzayn()) {
                this.pu = ((MenuItem)zzaa.zzy((Object)menuItem)).getActionView();
            }
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzaa.zzy((Object)activity);
            this.pu = (View)zzaa.zzy((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.pv = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.pw = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.pw = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.px = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.py = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.pz = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.pz = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.pA = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.pA = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzamd() {
            return this.pu;
        }

        public OnOverlayDismissedListener zzame() {
            return this.px;
        }

        public int zzamf() {
            return this.pv;
        }

        public boolean zzamg() {
            return this.py;
        }

        public String zzamh() {
            return this.pw;
        }

        public String zzami() {
            return this.pA;
        }

        public float zzamj() {
            return this.pz;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzayr()) {
                return new zzom(this);
            }
            return new zzon(this);
        }
    }

    public static class zza {
        public static void zzbc(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbd(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

